/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.error.RecipeComponentTooLargeException;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.EitherRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.IntBounds;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;

public record ListRecipeComponent<T>(RecipeComponent<T> component, boolean canWriteSelf, TypeInfo listTypeInfo, Codec<List<T>> listCodec, boolean conditional, IntBounds bounds, Optional<RecipeComponent<?>> spread, Optional<RecipeComponent<?>> spreadWrap) implements RecipeComponent<List<T>>
{
    public static final RecipeComponentType<?> TYPE = RecipeComponentType.dynamic(KubeJS.id("list"), (type, ctx) -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)ctx.recipeComponentCodec().fieldOf("component").forGetter(ListRecipeComponent::component), (App)Codec.BOOL.optionalFieldOf("can_write_self", (Object)false).forGetter(ListRecipeComponent::canWriteSelf), (App)Codec.BOOL.optionalFieldOf("conditional", (Object)false).forGetter(ListRecipeComponent::conditional), (App)IntBounds.MAP_CODEC.forGetter(ListRecipeComponent::bounds), (App)ctx.recipeComponentCodec().optionalFieldOf("spread").forGetter(ListRecipeComponent::spread)).apply((Applicative)instance, ListRecipeComponent::create)));

    public static <L> ListRecipeComponent<L> create(RecipeComponent<L> component, boolean canWriteSelf, boolean conditional) {
        return ListRecipeComponent.create(component, canWriteSelf, conditional, IntBounds.DEFAULT, Optional.empty());
    }

    public static <L> ListRecipeComponent<L> create(RecipeComponent<L> component, boolean canWriteSelf, boolean conditional, IntBounds bounds, Optional<RecipeComponent<?>> spread) {
        TypeInfo typeInfo = component.typeInfo();
        Codec<L> codec = component.codec();
        Codec<List<L>> listCodec = conditional ? NeoForgeExtraCodecs.listWithOptionalElements((Codec)ConditionalOps.createConditionalCodec(codec)) : codec.listOf();
        TypeInfo listTypeInfo = TypeInfo.RAW_LIST.withParams(new TypeInfo[]{typeInfo});
        if (canWriteSelf) {
            listCodec = KubeJSCodecs.listOfOrSelf(listCodec, codec);
            listTypeInfo = listTypeInfo.or(typeInfo);
        }
        Optional<RecipeComponent<?>> spreadWrap = ListRecipeComponent.wrapSpread(component, spread);
        return new ListRecipeComponent<L>(component, canWriteSelf, listTypeInfo, listCodec, conditional, bounds, spread, spreadWrap);
    }

    @NotNull
    private static <L> Optional<RecipeComponent<?>> wrapSpread(RecipeComponent<L> component, Optional<RecipeComponent<?>> spread) {
        Optional<RecipeComponent<?>> spreadWrap = spread;
        if (spread.isPresent() && component instanceof EitherRecipeComponent) {
            EitherRecipeComponent seither;
            EitherRecipeComponent either = (EitherRecipeComponent)component;
            RecipeComponent<?> recipeComponent = spread.get();
            if (recipeComponent instanceof EitherRecipeComponent && ((seither = (EitherRecipeComponent)recipeComponent).left().isIgnored() || seither.right().isIgnored())) {
                spreadWrap = Optional.of(seither.left().isIgnored() ? either.left().or(seither.right()) : seither.left().or(either.right()));
            }
        }
        return spreadWrap;
    }

    @Override
    public RecipeComponentType<?> type() {
        return TYPE;
    }

    @Override
    public Codec<List<T>> codec() {
        return this.listCodec;
    }

    @Override
    public TypeInfo typeInfo() {
        return this.listTypeInfo;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return from instanceof Iterable || from != null && from.getClass().isArray();
    }

    public static <T> List<T> wrap0(RecipeScriptContext cx, RecipeComponent<T> component, Object from) {
        if (from instanceof Iterable) {
            int size;
            Iterable iterable = (Iterable)from;
            if (iterable instanceof Collection) {
                Collection c = (Collection)iterable;
                size = c.size();
            } else if (iterable instanceof JsonArray) {
                JsonArray a = (JsonArray)iterable;
                size = a.size();
            } else {
                size = -1;
            }
            if (size == 0) {
                return List.of();
            }
            if (size == 1) {
                return List.of(component.wrap(cx, iterable.iterator().next()));
            }
            if (size == 2) {
                Iterator itr = iterable.iterator();
                return List.of(component.wrap(cx, itr.next()), component.wrap(cx, itr.next()));
            }
            if (size > 0) {
                ArrayList<T> arr = new ArrayList<T>(size);
                for (Object e : iterable) {
                    arr.add(component.wrap(cx, e));
                }
                return arr;
            }
            ArrayList<T> list = new ArrayList<T>();
            for (Object e : iterable) {
                list.add(component.wrap(cx, e));
            }
            return list;
        }
        if (from.getClass().isArray()) {
            int length = Array.getLength(from);
            if (length == 0) {
                return List.of();
            }
            ArrayList<T> arr = new ArrayList<T>(length);
            for (int i = 0; i < length; ++i) {
                arr.add(component.wrap(cx, Array.get(from, i)));
            }
            return arr;
        }
        return List.of(component.wrap(cx, from));
    }

    @Override
    public List<T> wrap(RecipeScriptContext cx, Object from) {
        RecipeComponent spreadComponent = this.spread.orElse(null);
        if (spreadComponent != null && this.spreadWrap.isPresent()) {
            List<?> original = ListRecipeComponent.wrap0(cx, this.spreadWrap.get(), from);
            ArrayList<T> result = new ArrayList<T>();
            for (Object o : original) {
                for (Object s : spreadComponent.spread(Cast.to(o))) {
                    result.add(this.component.wrap(cx, s));
                }
            }
            return result;
        }
        return ListRecipeComponent.wrap0(cx, this.component, from);
    }

    @Override
    public boolean matches(RecipeMatchContext cx, List<T> value, ReplacementMatchInfo match) {
        for (T v : value) {
            if (!this.component.matches(cx, v, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> replace(RecipeScriptContext cx, List<T> original, ReplacementMatchInfo match, Object with) {
        List<T> arr = original;
        for (int i = 0; i < original.size(); ++i) {
            T r = this.component.replace(cx, original.get(i), match, with);
            if (arr.get(i) == r) continue;
            if (arr == original) {
                arr = new ArrayList<T>(original);
            }
            if (arr == original) continue;
            arr.set(i, r);
        }
        return arr;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, List<T> value) {
        for (int i = 0; i < value.size(); ++i) {
            if (i > 0) {
                builder.appendSeparator();
            }
            this.component.buildUniqueId(builder, value.get(i));
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.component) + (this.canWriteSelf ? "[?]" : "[]") + (this.conditional ? "?" : "");
    }

    @Override
    public void validate(RecipeValidationContext ctx, List<T> value) {
        RecipeComponent.super.validate(ctx, value);
        if (value.size() > this.bounds.max()) {
            throw new RecipeComponentTooLargeException(this, value, value.size(), this.bounds.max());
        }
        ctx.errors().push(this);
        for (int i = 0; i < value.size(); ++i) {
            ctx.errors().setKey(i);
            this.component.validate(ctx, value.get(i));
        }
        ctx.errors().pop();
    }

    @Override
    public boolean allowEmpty() {
        return this.bounds.min() <= 0;
    }

    @Override
    public boolean isEmpty(List<T> value) {
        return value.isEmpty();
    }

    @Override
    public List<?> spread(List<T> value) {
        return value;
    }

    public ListRecipeComponent<T> withBounds(IntBounds bounds) {
        return ListRecipeComponent.create(this.component, this.canWriteSelf, this.conditional, bounds, this.spread);
    }

    @Override
    public ListRecipeComponent<T> orSelf() {
        return ListRecipeComponent.create(this.component, true, this.conditional, this.bounds, this.spread);
    }

    public ListRecipeComponent<T> asConditional() {
        return ListRecipeComponent.create(this.component, this.canWriteSelf, true, this.bounds, this.spread);
    }

    public ListRecipeComponent<T> withSpread(Optional<RecipeComponent<?>> spread) {
        return ListRecipeComponent.create(this.component, this.canWriteSelf, this.conditional, this.bounds, spread);
    }
}

