/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.highlight;

import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.net.WebServerUpdateNBTPayload;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.OrderedCompoundTag;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class KubedexPayloadHandler {
    private static ListTag sortedTagList(Stream<? extends TagKey<?>> stream) {
        return stream.map(TagKey::location).sorted(ResourceLocation::compareNamespaced).map(ResourceLocation::toString).map(StringTag::valueOf).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll);
    }

    private static CompoundTag flags(int flags) {
        OrderedCompoundTag tag = new OrderedCompoundTag();
        tag.putBoolean("shift", (flags & 1) != 0);
        tag.putBoolean("ctrl", (flags & 2) != 0);
        tag.putBoolean("alt", (flags & 4) != 0);
        return tag;
    }

    public static void block(ServerPlayer player, BlockPos pos, int flags) {
        RegistryAccess.Frozen registries = player.server.registryAccess();
        BlockState blockState = player.level().getBlockState(pos);
        if (!blockState.isAir()) {
            OrderedCompoundTag payload = new OrderedCompoundTag();
            payload.put("flags", (Tag)KubedexPayloadHandler.flags(flags));
            OrderedCompoundTag payloadBlock = new OrderedCompoundTag();
            payloadBlock.putString("id", blockState.getBlock().kjs$getId());
            payloadBlock.putString("dimension", player.level().dimension().location().toString());
            OrderedCompoundTag jpos = new OrderedCompoundTag();
            payloadBlock.put("pos", (Tag)jpos);
            jpos.putInt("x", pos.getX());
            jpos.putInt("y", pos.getY());
            jpos.putInt("z", pos.getZ());
            CompoundTag p = new CompoundTag();
            payloadBlock.put("properties", (Tag)p);
            for (Property pk : blockState.getBlock().getStateDefinition().getProperties()) {
                p.putString(pk.getName(), pk.getName((Comparable)Cast.to(blockState.getValue(pk))));
            }
            BlockEntity blockEntity = player.level().getBlockEntity(pos);
            if (blockEntity != null) {
                CompoundTag ejson = new CompoundTag();
                payloadBlock.put("block_entity", (Tag)ejson);
                ejson.putString("id", BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType()).toString());
                try {
                    ejson.put("components", (Tag)DataComponentMap.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)blockEntity.components()).result().get());
                }
                catch (Exception ex) {
                    ejson.put("components", (Tag)new CompoundTag());
                }
                try {
                    ejson.put("data", (Tag)blockEntity.saveCustomOnly((HolderLookup.Provider)registries));
                }
                catch (Exception ex) {
                    ejson.put("data", (Tag)new CompoundTag());
                }
            }
            payload.put("block", (Tag)payloadBlock);
            KubeJSNet.safeSendToPlayer(player, new WebServerUpdateNBTPayload("highlight/block", "highlight", Optional.of(payload)), new CustomPacketPayload[0]);
        }
    }

    public static void entity(ServerPlayer player, int entityId, int flags) {
        Entity entity = player.level().getEntity(entityId);
        if (entity != null) {
            OrderedCompoundTag payload = new OrderedCompoundTag();
            payload.put("flags", (Tag)KubedexPayloadHandler.flags(flags));
            OrderedCompoundTag payloadEntity = new OrderedCompoundTag();
            payloadEntity.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
            payloadEntity.putInt("network_id", entityId);
            payloadEntity.putString("unique_id", entity.getUUID().toString());
            payloadEntity.putString("dimension", player.level().dimension().location().toString());
            OrderedCompoundTag jpos = new OrderedCompoundTag();
            payloadEntity.put("pos", (Tag)jpos);
            jpos.putDouble("x", entity.position().x);
            jpos.putDouble("y", entity.position().y);
            jpos.putDouble("z", entity.position().z);
            try {
                payloadEntity.put("data", (Tag)entity.saveWithoutId(new CompoundTag()));
            }
            catch (Exception ex) {
                payloadEntity.put("data", (Tag)new CompoundTag());
            }
            payload.put("entity", (Tag)payloadEntity);
            KubeJSNet.safeSendToPlayer(player, new WebServerUpdateNBTPayload("highlight/entity", "highlight", Optional.of(payload)), new CustomPacketPayload[0]);
        }
    }

    public static void inventory(ServerPlayer player, List<Integer> slots, List<ItemStack> stacks, int flags) {
        LinkedHashSet<SlotItem> allStacks = new LinkedHashSet<SlotItem>();
        for (ItemStack s : stacks) {
            if (s.isEmpty()) continue;
            allStacks.add(new SlotItem(s, -1));
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            ItemStack item;
            int s = (Integer)iterator.next();
            if (s < 0 || s >= player.getInventory().getContainerSize() || (item = player.getInventory().getItem(s)).isEmpty()) continue;
            allStacks.add(new SlotItem(item, s));
        }
        KubedexPayloadHandler.itemStacks(player, allStacks, flags);
    }

    public static void itemStacks(ServerPlayer player, Collection<SlotItem> stacks, int flags) {
        RegistryOps ops = player.server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag payload = new CompoundTag();
        payload.put("flags", (Tag)KubedexPayloadHandler.flags(flags));
        ListTag payloadItems = new ListTag();
        for (SlotItem slotStack : stacks) {
            ListTag entityTagList;
            SpawnEggItem egg;
            EntityType entityType;
            Item fluidTagList;
            Item blockTagList;
            BlockItem blockItem;
            Item item;
            ListTag itemTagList;
            ItemStack stack = slotStack.item;
            OrderedCompoundTag tag = new OrderedCompoundTag();
            tag.putString("string", stack.kjs$toItemString0((DynamicOps)ops));
            tag.put("item", (Tag)ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)stack).result().get());
            tag.put("name", (Tag)ComponentSerialization.FLAT_CODEC.encodeStart((DynamicOps)ops, (Object)stack.getHoverName()).getOrThrow());
            tag.putString("icon", stack.kjs$getWebIconURL((DynamicOps)ops, 64).toString());
            tag.putInt("slot", slotStack.slot);
            DataComponentPatch patch = stack.getComponentsPatch();
            if (!patch.isEmpty()) {
                tag.putString("component_string", DataComponentWrapper.patchToString(new StringBuilder(), (DynamicOps<Tag>)ops, patch).toString());
            }
            if (!(itemTagList = KubedexPayloadHandler.sortedTagList(stack.getItemHolder().tags())).isEmpty()) {
                tag.put("tags", (Tag)itemTagList);
            }
            if ((item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() != Blocks.AIR && !(blockTagList = KubedexPayloadHandler.sortedTagList(blockItem.getBlock().builtInRegistryHolder().tags())).isEmpty()) {
                tag.put("block_tags", (Tag)blockTagList);
            }
            if ((blockTagList = stack.getItem()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)blockTagList;
                if (bucket.content != Fluids.EMPTY && !(fluidTagList = KubedexPayloadHandler.sortedTagList(bucket.content.builtInRegistryHolder().tags())).isEmpty()) {
                    tag.put("fluid_tags", (Tag)fluidTagList);
                }
            }
            if ((fluidTagList = stack.getItem()) instanceof SpawnEggItem && (entityType = (egg = (SpawnEggItem)fluidTagList).getType(stack)) != null && !(entityTagList = KubedexPayloadHandler.sortedTagList(entityType.builtInRegistryHolder().tags())).isEmpty()) {
                tag.put("entity_tags", (Tag)entityTagList);
            }
            payloadItems.add((Object)tag);
        }
        payload.put("items", (Tag)payloadItems);
        KubeJSNet.safeSendToPlayer(player, new WebServerUpdateNBTPayload("highlight/items", "highlight", Optional.of(payload)), new CustomPacketPayload[0]);
    }

    public record SlotItem(ItemStack item, int slot) {
    }
}

