/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.kubejs.entity.KubeEntityEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import org.jetbrains.annotations.Nullable;

@Info(value="Modify dropped items and xp from block.\n")
public class BlockDropsKubeEvent
implements KubeEntityEvent {
    private final BlockDropsEvent event;

    public BlockDropsKubeEvent(BlockDropsEvent event) {
        this.event = event;
    }

    public ServerLevel getLevel() {
        return this.event.getLevel();
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.event.getBreaker();
    }

    @Info(value="The block that was broken.")
    public LevelBlock getBlock() {
        return this.event.getLevel().kjs$getBlock(this.event.getPos()).cache(this.event.getState()).cache(this.event.getBlockEntity());
    }

    @Info(value="The experience dropped by the block.")
    public int getXp() {
        return this.event.getDroppedExperience();
    }

    @Info(value="Sets the experience dropped by the block.")
    public void setXp(int xp) {
        this.event.setDroppedExperience(xp);
    }

    @Info(value="Dropped item entities.")
    public List<ItemEntity> getItemEntities() {
        return this.event.getDrops();
    }

    @Info(value="Dropped items. Immutable.")
    public List<ItemStack> getItems() {
        return this.event.getDrops().stream().map(ItemEntity::getItem).toList();
    }

    public boolean containsItem(ItemPredicate item) {
        for (ItemEntity drop : this.event.getDrops()) {
            if (!item.test(drop.getItem())) continue;
            return true;
        }
        return false;
    }

    public ItemEntity addItem(ItemStack item) {
        double x = (double)this.event.getPos().getX() + 0.5 + Mth.nextDouble((RandomSource)this.event.getLevel().random, (double)-0.25, (double)0.25);
        double y = (double)this.event.getPos().getY() + 0.5 + Mth.nextDouble((RandomSource)this.event.getLevel().random, (double)-0.25, (double)0.25) - (double)EntityType.ITEM.getHeight() / 2.0;
        double z = (double)this.event.getPos().getZ() + 0.5 + Mth.nextDouble((RandomSource)this.event.getLevel().random, (double)-0.25, (double)0.25);
        ItemEntity entity = new ItemEntity((Level)this.event.getLevel(), x, y, z, item);
        this.event.getDrops().add(entity);
        return entity;
    }

    public void removeItem(ItemPredicate item) {
        this.event.getDrops().removeIf(drop -> item.test(drop.getItem()));
    }

    @Info(value="The tool used when breaking this block. May be null.")
    @Nullable
    public ItemStack getTool() {
        return this.event.getTool().isEmpty() ? null : this.event.getTool();
    }
}

