/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.HorizontalSlabConverter;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.converter.VerticalSlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockBreakHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void onBreakBlock(BreakBlockEvent event) {
        Item slabItem;
        BlockState newState;
        BlockState dropState;
        BlockState state;
        SlabConverter slabConverter;
        Vec3 hitVec;
        if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
            return;
        }
        if (!KleeSlabs.isPlayerKleeSlabbing(event.getPlayer())) {
            return;
        }
        BlockHitResult rayTraceResult = BlockBreakHandler.rayTrace((LivingEntity)event.getPlayer(), Balm.getHooks().getBlockReachDistance(event.getPlayer()));
        Direction hitSide = rayTraceResult.getDirection();
        Vec3 vec3 = hitVec = rayTraceResult.getType() == HitResult.Type.BLOCK ? rayTraceResult.getLocation() : null;
        if (hitVec != null) {
            hitVec = hitVec.add((double)(-event.getPos().getX()), (double)(-event.getPos().getY()), (double)(-event.getPos().getZ()));
        }
        if ((slabConverter = SlabRegistry.getSlabConverter((state = event.getState()).getBlock())) == null || !slabConverter.isDoubleSlab(state)) {
            return;
        }
        if (slabConverter instanceof HorizontalSlabConverter) {
            SlabType stay;
            SlabType hit;
            HorizontalSlabConverter horizontalSlabConverter = (HorizontalSlabConverter)slabConverter;
            if (hitVec != null && hitVec.y > 0.5) {
                hit = SlabType.TOP;
                stay = SlabType.BOTTOM;
            } else {
                stay = SlabType.TOP;
                hit = SlabType.BOTTOM;
            }
            dropState = horizontalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hit);
            newState = horizontalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), stay);
        } else {
            if (!(slabConverter instanceof VerticalSlabConverter)) return;
            VerticalSlabConverter verticalSlabConverter = (VerticalSlabConverter)slabConverter;
            if (hitSide.getAxis() == Direction.Axis.Y) return;
            dropState = verticalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hitSide.getOpposite());
            newState = verticalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hitSide);
        }
        Level level = event.getLevel();
        if (!level.isClientSide() && event.getPlayer().hasCorrectToolForDrops(dropState) && !event.getPlayer().getAbilities().instabuild && (slabItem = Item.byBlock((Block)dropState.getBlock())) != Items.AIR) {
            ItemStack itemStack = new ItemStack((ItemLike)slabItem);
            float scale = 0.7f;
            double xOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            double yOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            double zOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            ItemEntity entityItem = new ItemEntity(level, (double)event.getPos().getX() + xOffset, (double)event.getPos().getY() + yOffset, (double)event.getPos().getZ() + zOffset, itemStack);
            entityItem.setPickUpDelay(10);
            level.addFreshEntity((Entity)entityItem);
        }
        event.getLevel().setBlock(event.getPos(), newState, 3);
        event.setCanceled(true);
    }

    public static BlockHitResult rayTrace(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 endPos = startPos.add(entity.getLookAngle().x * length, entity.getLookAngle().y * length, entity.getLookAngle().z * length);
        ClipContext rayTraceContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(rayTraceContext);
    }
}

