/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.helper.ColorHelper;
import org.joml.Vector3f;

public final class AestheticTeslaCoilComponent
implements IComponent {
    private final List<Model> models = Lists.newArrayList();
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private int selectedModelIndex;

    public AestheticTeslaCoilComponent with(ResourceLocation path, Component text) {
        this.models.add(new Model(path, text));
        return this;
    }

    public float red() {
        return this.red;
    }

    public int redInt() {
        return (int)(this.red * 255.0f);
    }

    public float green() {
        return this.green;
    }

    public int greenInt() {
        return (int)(this.green * 255.0f);
    }

    public float blue() {
        return this.blue;
    }

    public int blueInt() {
        return (int)(this.blue * 255.0f);
    }

    public Vector3f getColor() {
        return new Vector3f(this.red, this.green, this.blue);
    }

    public ResourceLocation getSelectedModel() {
        return this.models.get(this.selectedModelIndex).path();
    }

    public ItemInteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stackInHand.getItem();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            int color = ColorHelper.getVibrantColor((DyeColor)item2.getDyeColor());
            this.red = (float)(color >> 16 & 0xFF) / 255.0f;
            this.green = (float)(color >> 8 & 0xFF) / 255.0f;
            this.blue = (float)(color & 0xFF) / 255.0f;
            be.setChanged();
            be.sync();
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag colorTag = new CompoundTag();
        colorTag.putFloat("red", this.red);
        colorTag.putFloat("green", this.green);
        colorTag.putFloat("blue", this.blue);
        tag.put("tesla_color", (Tag)colorTag);
        tag.putInt("tesla_selected_model", this.selectedModelIndex);
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        if (tag.contains("tesla_color", 10)) {
            CompoundTag colorTag = tag.getCompound("tesla_color");
            this.red = colorTag.getFloat("red");
            this.green = colorTag.getFloat("green");
            this.blue = colorTag.getFloat("blue");
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
        }
        this.selectedModelIndex = tag.getInt("tesla_selected_model");
    }

    private List<Component> createColorTranslations(Component prefix) {
        ArrayList lines = Lists.newArrayList();
        for (int i = 0; i <= 17; ++i) {
            int color = i * 15;
            lines.add(prefix.copy().append((Component)Component.literal((String)String.valueOf(color))));
        }
        return lines;
    }

    private void appendColorLine(ConfigurationPanelBuilder builder, Component prefix, Supplier<Integer> colorIntGetter, Consumer<Float> colorSetter) {
        builder.add(this.createColorTranslations(prefix), false, delta -> {
            int color = Math.clamp((long)((Integer)colorIntGetter.get()).intValue() + (long)delta * 15L, 0, 255);
            colorSetter.accept(Float.valueOf((float)color / 255.0f));
        }, () -> (Integer)colorIntGetter.get() / 15);
    }

    public void appendSelectionPanel(MachineBlockEntity machine, ConfigurationPanelBuilder builder) {
        if (!this.models.isEmpty()) {
            ArrayList modelLines = Lists.newArrayList();
            for (Model model : this.models) {
                modelLines.add(model.text());
            }
            builder.add((List)modelLines, true, delta -> {
                int newIndex = this.selectedModelIndex + delta;
                if (newIndex >= 0 && newIndex < this.models.size()) {
                    this.selectedModelIndex = newIndex;
                }
            }, () -> this.selectedModelIndex);
        }
        this.appendColorLine(builder, (Component)EI.text().colorRed(), this::redInt, color -> {
            this.red = color.floatValue();
        });
        this.appendColorLine(builder, (Component)EI.text().colorGreen(), this::greenInt, color -> {
            this.green = color.floatValue();
        });
        this.appendColorLine(builder, (Component)EI.text().colorBlue(), this::blueInt, color -> {
            this.blue = color.floatValue();
        });
    }

    public record Model(ResourceLocation path, Component text) {
    }
}

