/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.harvesting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehavior;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;

public interface LootTableHarvestableBehavior
extends HarvestableBehavior {
    @Override
    default public List<ItemStack> getDrops(HarvestingContext context) {
        List<BlockPos> blocks = this.getBlocks(context);
        ArrayList drops = Lists.newArrayList();
        for (BlockPos block : blocks) {
            HarvestingContext blockContext = new HarvestingContext(context.level(), block, context.level().getBlockState(block), context.enchantment(), context.tier());
            LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)context.level()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)block)).withParameter(LootContextParams.TOOL, (Object)blockContext.enchantedItem());
            drops.addAll(blockContext.state().getDrops(lootParams));
        }
        return drops;
    }
}

