/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.ChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.InventoryWrapper;
import net.swedz.tesseract.neoforge.helper.TransferHelper;

public final class ChainerEnergyHandler
extends ChainerHandler<MIEnergyStorage, InventoryWrapper<MIEnergyStorage>>
implements MIEnergyStorage {
    private final Supplier<CableTier> cableTier;
    private final boolean insertable;

    public ChainerEnergyHandler(ChainerLinks chainerLinks, Supplier<CableTier> cableTier, boolean insertable) {
        super(chainerLinks);
        this.cableTier = cableTier;
        this.insertable = insertable;
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        for (MIEnergyStorage handler : this.getMachineLinks().energyHandlers()) {
            if (!handler.canConnect(this.cableTier.get())) continue;
            wrappers.add(new InventoryWrapper<MIEnergyStorage>(handler));
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.wrappersSlotMap = Maps.newConcurrentMap();
    }

    public long receive(long maxReceive, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation() || !this.insertable) {
            return 0L;
        }
        return TransferHelper.distributeLong((wrapper, amount, opSimulate) -> ((MIEnergyStorage)wrapper.handler()).receive(amount, opSimulate), (List)this.wrappers, (long)maxReceive, (boolean)simulate);
    }

    public long extract(long maxExtract, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation() || this.insertable) {
            return 0L;
        }
        return TransferHelper.distributeLong((wrapper, amount, opSimulate) -> ((MIEnergyStorage)wrapper.handler()).extract(amount, opSimulate), (List)this.wrappers, (long)maxExtract, (boolean)simulate);
    }

    public long getAmount() {
        return this.wrappers.stream().mapToLong(w -> ((MIEnergyStorage)w.handler()).getAmount()).sum();
    }

    public long getCapacity() {
        return this.wrappers.stream().mapToLong(w -> ((MIEnergyStorage)w.handler()).getCapacity()).sum();
    }

    public boolean canExtract() {
        return !this.insertable;
    }

    public boolean canReceive() {
        return this.insertable;
    }

    public boolean canConnect(CableTier other) {
        return this.cableTier.get() == other;
    }
}

