/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.tesla;

import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.ForceHideTeslaComponent;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.joml.Vector3f;

public final class TeslaParticleGeneratorMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
TeslaBehavior {
    private final IsActiveComponent isActive = new IsActiveComponent();
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final AestheticTeslaCoilComponent aesthetic = new AestheticTeslaCoilComponent().with(EI.id("tesla/tesla_particle_generator/small"), (Component)EI.text().teslaParticleGeneratorSizeSmall()).with(EI.id("tesla/tesla_particle_generator/medium"), (Component)EI.text().teslaParticleGeneratorSizeMedium()).with(EI.id("tesla/tesla_particle_generator/large"), (Component)EI.text().teslaParticleGeneratorSizeLarge()).with(EI.id("tesla/tesla_particle_generator/extreme"), (Component)EI.text().teslaParticleGeneratorSizeExtreme()).with(EI.id("tesla/tesla_particle_generator/immense"), (Component)EI.text().teslaParticleGeneratorSizeImmense());
    private final ForceHideTeslaComponent forceHideRender = new ForceHideTeslaComponent();

    public TeslaParticleGeneratorMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("tesla_particle_generator"), false).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(new IComponent[]{this.isActive, this.redstoneControl, this.aesthetic, this.forceHideRender});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularSlotPanel.Server((MachineBlockEntity)this, 0).withRedstoneModule(this.redstoneControl)});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EI.text().configurationPanel(), (Component)EI.text().configurationPanelDescription(), (lineIndex, delta) -> this.sync());
        this.aesthetic.appendSelectionPanel(this, configPanel);
        this.registerGuiComponent(new GuiComponent.Server[]{configPanel.build()});
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive && !this.forceHideRender.isHidden();
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return this.aesthetic.getSelectedModel();
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActive.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
        }
    }

    public void tick() {
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            return;
        }
        this.isActive.updateActive(this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this), (MachineBlockEntity)this);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse(this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        return List.of(EI.text().teslaParticleGeneratorHelp());
    }
}

