/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.brewery;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIMachines;

public abstract class BreweryMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
CrafterComponentHolder,
CrafterComponent.Behavior {
    protected final MachineTier tier;
    protected final MachineInventoryComponent inventory;
    protected final CrafterComponent crafter;
    protected IsActiveComponent isActiveComponent;

    public BreweryMachineBlockEntity(BEP bep, MachineTier tier, MachineGuiParameters guiParams, MachineInventoryComponent inventory) {
        super(bep, guiParams, new OrientationComponent.Params(true, true, false));
        this.tier = tier;
        this.inventory = inventory;
        this.crafter = new CrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)inventory, (CrafterComponent.Behavior)this);
        this.isActiveComponent = new IsActiveComponent();
        this.registerComponents(new IComponent[]{this.isActiveComponent, inventory, this.crafter});
        this.registerGuiComponent(new GuiComponent.Server[]{new AutoExtract.Server(this.orientation)});
    }

    public MIInventory getInventory() {
        return this.inventory.inventory;
    }

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    public MachineRecipeType recipeType() {
        return EIMachines.RecipeTypes.BREWERY;
    }

    public ServerLevel getCrafterWorld() {
        return (ServerLevel)this.level;
    }

    public UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }

    public long getBaseRecipeEu() {
        return this.tier.getBaseEu();
    }

    public long getMaxRecipeEu() {
        return this.tier.getMaxEu();
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.updateActive(this.crafter.tickRecipe());
        if (this.orientation.extractItems) {
            this.getInventory().autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        this.setChanged();
    }

    private void updateActive(boolean active) {
        this.isActiveComponent.updateActive(active, (MachineBlockEntity)this);
    }

    public List<Component> getTooltips() {
        return List.of(EI.text().breweryRequiresBlazingEssence(EIFluids.BLAZING_ESSENCE.asFluid()), EI.text().breweryBrewsMultiple(4));
    }
}

