/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.lootmodifier;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public final class AutoSmeltLootModifier
extends LootModifier {
    public static final MapCodec<AutoSmeltLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, AutoSmeltLootModifier::new));

    public AutoSmeltLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        ItemStack result;
        Optional recipe = context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel());
        if (recipe.isPresent() && !(result = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)context.getLevel().registryAccess())).isEmpty()) {
            return result.copyWithCount(stack.getCount() * result.getCount());
        }
        return stack;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> items, LootContext context) {
        ObjectArrayList modifiedItems = new ObjectArrayList();
        for (ItemStack stack : items) {
            modifiedItems.add((Object)AutoSmeltLootModifier.smelt(stack, context));
        }
        return modifiedItems;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

