/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.swedz.extended_industrialization.lootmodifier.AutoSmeltLootModifier;
import net.swedz.extended_industrialization.lootmodifier.BeheadingLootModifier;
import net.swedz.extended_industrialization.lootmodifier.ElectricToolModePredicate;

public final class EILootModifiers {
    public static void init(IEventBus bus) {
        LootModifiers.LOOT_MODIFIERS.register(bus);
        ItemSubPredicates.ITEM_SUB_PREDICATE_TYPES.register(bus);
    }

    public static final class LootModifiers {
        private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"extended_industrialization");
        public static final Supplier<MapCodec<AutoSmeltLootModifier>> AUTO_SMELT = LootModifiers.create("auto_smelt", AutoSmeltLootModifier.CODEC);
        public static final Supplier<MapCodec<BeheadingLootModifier>> BEHEADING = LootModifiers.create("beheading", BeheadingLootModifier.CODEC);

        private static <T extends IGlobalLootModifier> Supplier<MapCodec<T>> create(String name, MapCodec<T> codec) {
            return LOOT_MODIFIERS.register(name, () -> codec);
        }
    }

    public static final class ItemSubPredicates {
        private static final DeferredRegister<ItemSubPredicate.Type<?>> ITEM_SUB_PREDICATE_TYPES = DeferredRegister.create((ResourceKey)Registries.ITEM_SUB_PREDICATE_TYPE, (String)"extended_industrialization");
        public static final Supplier<ItemSubPredicate.Type<ElectricToolModePredicate>> ELECTRIC_TOOL_MODE = ItemSubPredicates.create("electric_tool_mode", ElectricToolModePredicate.CODEC);

        private static <T extends ItemSubPredicate> Supplier<ItemSubPredicate.Type<T>> create(String name, Codec<T> codec) {
            return ITEM_SUB_PREDICATE_TYPES.register(name, () -> new ItemSubPredicate.Type(codec));
        }
    }
}

