/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.InitialConstruct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.commonmark.BlankLine;
import guideme.libs.micromark.commonmark.Content;
import guideme.libs.micromark.factory.FactorySpace;

public final class InitializeFlow {
    public static final InitialConstruct flow = new InitialConstruct();

    private InitializeFlow() {
    }

    static {
        InitializeFlow.flow.tokenize = (context, effects, ok, nok) -> new StateMachine((TokenizeContext)context, (Tokenizer.Effects)effects).initial;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        public final State initial;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects) {
            this.context = context;
            this.effects = effects;
            this.initial = effects.attempt.hook(BlankLine.blankLine, this::atBlankEnding, effects.attempt.hook(context.getParser().constructs.flowInitial, this::afterConstruct, FactorySpace.create(effects, effects.attempt.hook(context.getParser().constructs.flow, this::afterConstruct, effects.attempt.hook(Content.content, this::afterConstruct, null)), "linePrefix")));
        }

        private State atBlankEnding(int code) {
            if (code != Integer.MIN_VALUE && !CharUtil.markdownLineEnding(code)) {
                throw new IllegalStateException("expected eol or eof");
            }
            if (code == Integer.MIN_VALUE) {
                this.effects.consume(code);
                return null;
            }
            this.effects.enter("lineEndingBlank");
            this.effects.consume(code);
            this.effects.exit("lineEndingBlank");
            this.context.setCurrentConstruct(null);
            return this.initial;
        }

        private State afterConstruct(int code) {
            if (code != Integer.MIN_VALUE && !CharUtil.markdownLineEnding(code)) {
                throw new IllegalStateException("expected eol or eof");
            }
            if (code == Integer.MIN_VALUE) {
                this.effects.consume(code);
                return null;
            }
            this.effects.enter("lineEnding");
            this.effects.consume(code);
            this.effects.exit("lineEnding");
            this.context.setCurrentConstruct(null);
            return this.initial;
        }
    }
}

