/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.config.CommonConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class EarlyWarning {
    public static boolean showEarlyScreenFor(String message, URI link) {
        boolean result = TinyFileDialogs.tinyfd_messageBox((CharSequence)"Memory Settings", (CharSequence)message, (CharSequence)"okcancel", (CharSequence)"info", (boolean)true);
        if (result) {
            if (link != null) {
                EarlyWarning.getPlatform().openUri(link);
            }
            Runtime.getRuntime().exit(0);
        }
        return result;
    }

    public static OS getPlatform() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (s.contains("win")) {
            return OS.WINDOWS;
        }
        if (s.contains("mac")) {
            return OS.OSX;
        }
        if (s.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (s.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (s.contains("linux")) {
            return OS.LINUX;
        }
        return s.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
            }
        }
        ,
        OSX{

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"open", uri.toString()};
            }
        }
        ,
        UNKNOWN;


        public void openUri(URI uri) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenUriArguments(uri)));
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException privilegedactionexception) {
                CommonConfiguration.LOGGER.error("Couldn't open location '{}'", (Object)uri, (Object)privilegedactionexception);
            }
        }

        public void openFile(File file) {
            this.openUri(file.toURI());
        }

        public void openPath(Path path) {
            this.openUri(path.toUri());
        }

        protected String[] getOpenUriArguments(URI uri) {
            String s = uri.toString();
            if ("file".equals(uri.getScheme())) {
                s = s.replace("file:", "file://");
            }
            return new String[]{"xdg-open", s};
        }

        public void openUri(String uri) {
            try {
                this.openUri(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException urisyntaxexception) {
                CommonConfiguration.LOGGER.error("Couldn't open uri '{}'", (Object)uri, (Object)urisyntaxexception);
            }
        }
    }
}

