/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientStack(Ingredient ingredient, int count) {
    public static final Codec<IngredientStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(IngredientStack::ingredient), (App)ExtraCodecs.intRange((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(IngredientStack::count)).apply((Applicative)instance, IngredientStack::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientStack> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientStack::ingredient, (StreamCodec)ByteBufCodecs.INT, IngredientStack::count, IngredientStack::new);

    public boolean test(ItemStack itemStack) {
        return itemStack.getCount() >= this.count && this.ingredient.test(itemStack);
    }

    public boolean test(Item item) {
        return this.ingredient.test(item.getDefaultInstance());
    }
}

