/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.permutated.exmachinis.machines.base.AbstractMachineMenu;
import net.permutated.exmachinis.util.ResourceUtil;
import net.permutated.exmachinis.util.TextureHolder;
import net.permutated.exmachinis.util.TranslationKey;
import net.permutated.exmachinis.util.WorkStatus;

public class AbstractMachineScreen<T extends AbstractMachineMenu>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation gui;

    protected AbstractMachineScreen(T container, Inventory inv, Component name, String machine) {
        super(container, inv, name);
        this.gui = ResourceUtil.gui(machine);
    }

    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int statusOffsetX;
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.gui, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        int n = statusOffsetX = ((AbstractMachineMenu)this.menu).enableComparatorSlot ? 134 : 116;
        if (((AbstractMachineMenu)this.menu).getWorkStatus() == WorkStatus.WORKING) {
            graphics.blit(this.gui, relX + statusOffsetX, relY + 36, 224, 0, 16, 16);
        } else if (((AbstractMachineMenu)this.menu).getWorkStatus() == WorkStatus.REDSTONE_DISABLED) {
            graphics.blit(this.gui, relX + statusOffsetX, relY + 36, 240, 0, 16, 16);
        } else {
            graphics.blit(this.gui, relX + statusOffsetX, relY + 36, 208, 0, 16, 16);
        }
        if (!((AbstractMachineMenu)this.menu).enableComparatorSlot) {
            float energyFraction = ((AbstractMachineMenu)this.menu).dataHolder.getEnergyFraction();
            TextureHolder energyHolder = new TextureHolder(152, 18, 176, 0, 16, 52);
            graphics.blit(this.gui, relX + energyHolder.progressOffsetX(), relY + energyHolder.progressHeightOffset(energyFraction), energyHolder.textureOffsetX(), energyHolder.textureOffsetY(), energyHolder.textureWidth(), energyHolder.getHeightFraction(energyFraction));
        }
        float workFraction = ((AbstractMachineMenu)this.menu).dataHolder.getWorkFraction();
        int progressOffsetX = ((AbstractMachineMenu)this.menu).enableComparatorSlot ? 152 : 134;
        TextureHolder progressHolder = new TextureHolder(progressOffsetX, 18, 192, 0, 16, 52);
        graphics.blit(this.gui, relX + progressHolder.progressOffsetX(), relY + progressHolder.progressHeightOffset(workFraction), progressHolder.textureOffsetX(), progressHolder.textureOffsetY(), progressHolder.textureWidth(), progressHolder.getHeightFraction(workFraction));
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        int progressOffsetX;
        super.renderTooltip(graphics, x, y);
        int upgradeOffsetX = ((AbstractMachineMenu)this.menu).enableComparatorSlot ? 134 : 116;
        int n = progressOffsetX = ((AbstractMachineMenu)this.menu).enableComparatorSlot ? 152 : 134;
        if (this.isHovering(upgradeOffsetX, 36, 16, 16, x, y)) {
            graphics.renderComponentTooltip(this.font, List.of(((AbstractMachineMenu)this.menu).getWorkStatus().getTranslation()), x, y);
        }
        if (this.isHovering(152, 18, 16, 52, x, y) && !((AbstractMachineMenu)this.menu).enableComparatorSlot) {
            graphics.renderComponentTooltip(this.font, List.of(TranslationKey.translateTooltip("fluxBar"), TranslationKey.translateTooltip("fluxData", ((AbstractMachineMenu)this.menu).dataHolder.getEnergy(), ((AbstractMachineMenu)this.menu).dataHolder.getMaxEnergy())), x, y);
        }
        if (this.isHovering(progressOffsetX, 18, 16, 52, x, y)) {
            graphics.renderComponentTooltip(this.font, List.of(TranslationKey.translateTooltip("workBar"), TranslationKey.translateTooltip("workData", ((AbstractMachineMenu)this.menu).dataHolder.getWork(), ((AbstractMachineMenu)this.menu).dataHolder.getMaxWork())), x, y);
        }
        if (this.isHovering(upgradeOffsetX, 54, 16, 16, x, y) && this.shouldShowSlotTooltip()) {
            graphics.renderComponentTooltip(this.font, List.of(TranslationKey.translateTooltip("upgradeSlot")), x, y);
        }
        if (this.isHovering(upgradeOffsetX, 18, 16, 16, x, y) && ((AbstractMachineMenu)this.menu).enableComparatorSlot && this.shouldShowSlotTooltip()) {
            graphics.renderComponentTooltip(this.font, List.of(TranslationKey.translateTooltip("comparatorSlot")), x, y);
        }
        if (this.isHovering(80, 36, 16, 16, x, y) && ((AbstractMachineMenu)this.menu).enableMeshSlot && this.shouldShowSlotTooltip()) {
            graphics.renderComponentTooltip(this.font, List.of(TranslationKey.translateTooltip("meshSlot")), x, y);
        }
    }

    private boolean shouldShowSlotTooltip() {
        return ((AbstractMachineMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem();
    }
}

