/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineMenu;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;

public abstract class AbstractMachineBlock
extends Block
implements EntityBlock {
    public static final int VERSION = 1;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final DirectionProperty OUTPUT = DirectionProperty.create((String)"output");

    protected AbstractMachineBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 3.0f).noOcclusion().isRedstoneConductor((state, getter, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.TRUE)).setValue((Property)OUTPUT, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENABLED, OUTPUT});
    }

    public abstract IContainerFactory<AbstractMachineMenu> containerFactory();

    public abstract BlockEntityType<? extends AbstractMachineTile> getTileType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == this.getTileType() ? AbstractMachineTile::tick : null;
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof AbstractMachineTile) {
            AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
            machineTile.dropItems();
        }
        super.destroy(world, blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractMachineTile) {
                AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
                machineTile.dropItems();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.hasNeighborSignal(pos);
        if (!Boolean.valueOf(flag).equals(state.getValue((Property)ENABLED))) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, final Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof AbstractMachineTile) {
                final AbstractMachineTile machineTile = (AbstractMachineTile)tileEntity;
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)AbstractMachineBlock.this.getDescriptionId());
                    }

                    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess(), ConnectionType.NEOFORGE);
                        machineTile.updateContainer((FriendlyByteBuf)buffer);
                        return AbstractMachineBlock.this.containerFactory().create(i, playerInventory, buffer);
                    }
                };
                player.openMenu(containerProvider, machineTile::updateContainer);
            } else {
                ExMachinis.LOGGER.error("tile entity not instance of AbstractMachineTile");
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof AbstractMachineTile) {
                Item item;
                AbstractMachineTile machineTile = (AbstractMachineTile)tileEntity;
                ItemStack stackInHand = player.getItemInHand(hand).copy();
                if (!stackInHand.isEmpty() && (item = stackInHand.getItem()) instanceof UpgradeItem) {
                    UpgradeItem handItem = (UpgradeItem)item;
                    ItemStack inSlot = machineTile.upgradeStackHandler.getStackInSlot(0).copy();
                    if (player.isCreative()) {
                        if (!ItemStack.matches((ItemStack)inSlot, (ItemStack)stackInHand)) {
                            machineTile.upgradeStackHandler.setStackInSlot(0, stackInHand);
                            return ItemInteractionResult.SUCCESS;
                        }
                    } else if (inSlot.isEmpty()) {
                        ItemStack result = machineTile.upgradeStackHandler.insertItem(0, stackInHand, true);
                        if (result.isEmpty()) {
                            ItemStack actual = machineTile.upgradeStackHandler.insertItem(0, stackInHand, false);
                            player.setItemInHand(hand, actual);
                            return ItemInteractionResult.SUCCESS;
                        }
                    } else if (inSlot.is(stackInHand.getItem())) {
                        if (inSlot.getCount() < inSlot.getMaxStackSize()) {
                            ItemStack result = machineTile.upgradeStackHandler.insertItem(0, stackInHand, true);
                            int maxInsert = inSlot.getMaxStackSize() - inSlot.getCount();
                            int expectedToRemain = Math.max(stackInHand.getCount() - maxInsert, 0);
                            if (expectedToRemain == result.getCount()) {
                                ItemStack actual = machineTile.upgradeStackHandler.insertItem(0, stackInHand, false);
                                player.setItemInHand(hand, actual);
                                return ItemInteractionResult.SUCCESS;
                            }
                        }
                    } else {
                        Item item2 = inSlot.getItem();
                        if (item2 instanceof UpgradeItem) {
                            UpgradeItem slotItem = (UpgradeItem)item2;
                            if (handItem.getTier().compareTo(slotItem.getTier()) > 0) {
                                machineTile.upgradeStackHandler.setStackInSlot(0, stackInHand);
                                player.setItemInHand(hand, inSlot);
                                return ItemInteractionResult.SUCCESS;
                            }
                        }
                    }
                }
            } else {
                ExMachinis.LOGGER.error("tile entity not instance of AbstractMachineTile");
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

