/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.util.TranslationKey;

public class UpgradeItem
extends Item {
    private final Tier tier;

    public UpgradeItem(Tier tier) {
        super(new Item.Properties().stacksTo(tier.stackSize).setNoRepair());
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        int cost = 0;
        int time = 1;
        switch (this.getTier().ordinal()) {
            case 0: {
                cost = (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
                break;
            }
            case 1: {
                cost = (Integer)ConfigHolder.SERVER.diamondEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.diamondTicksPerOperation.get();
                break;
            }
            case 2: {
                cost = (Integer)ConfigHolder.SERVER.netheriteEnergyPerBlock.get();
                time = (Integer)ConfigHolder.SERVER.netheriteTicksPerOperation.get();
            }
        }
        MutableComponent stackSize = Component.empty();
        MutableComponent itemsProcessed = Component.empty();
        MutableComponent energyPerTick = Component.empty();
        for (int i = 1; i <= this.getTier().stackSize; ++i) {
            ChatFormatting style = i == stack.getCount() ? ChatFormatting.WHITE : ChatFormatting.GRAY;
            int count = this.getTier().getItemsProcessed(i);
            int perTick = count * cost / time;
            stackSize.append((Component)Component.literal((String)String.valueOf(i)).withStyle(style));
            itemsProcessed.append((Component)Component.literal((String)String.valueOf(count)).withStyle(style));
            energyPerTick.append((Component)Component.literal((String)String.valueOf(perTick)).withStyle(style));
            if (i >= this.getTier().stackSize) continue;
            stackSize.append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY));
            itemsProcessed.append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY));
            energyPerTick.append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)TranslationKey.translateTooltip("stackSize", stackSize).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("itemsProcessed", itemsProcessed).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("energyPerTick", energyPerTick).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("costPerBlock", cost).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TranslationKey.translateTooltip("processingTime", time).withStyle(ChatFormatting.GRAY));
    }

    public static enum Tier {
        GOLD(3),
        DIAMOND(3),
        NETHERITE(1);

        final int stackSize;

        private Tier(int stackSize) {
            this.stackSize = stackSize;
        }

        public int getItemsProcessed(int stackCount) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 1 << stackCount;
                case 1 -> 1 << 3 + stackCount;
                case 2 -> 64;
            };
        }
    }
}

