/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.util.TranslationKey;

public class CompactingCategory
implements IRecipeCategory<CompactingRecipe> {
    private final IDrawable icon;
    private final MutableComponent title;
    private final IGuiHelper guiHelper;
    public static final RecipeType<CompactingRecipe> RECIPE_TYPE = RecipeType.create((String)"exmachinis", (String)"compacting", CompactingRecipe.class);

    public CompactingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()));
        this.title = Component.translatable((String)TranslationKey.jei("compacting"));
        this.guiHelper = guiHelper;
    }

    public int getWidth() {
        return 82;
    }

    public int getHeight() {
        return 26;
    }

    public void draw(CompactingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 0, 4);
        this.guiHelper.getRecipeArrow().draw(guiGraphics, 25, 5);
        this.guiHelper.getOutputSlot().draw(guiGraphics, 56, 0);
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<CompactingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompactingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = Arrays.stream(recipe.getIngredient().ingredient().getItems()).map(stack -> stack.copyWithCount(recipe.getIngredient().count())).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5).addItemStack(recipe.getOutput());
    }
}

