/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.exnihilo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.permutated.exmachinis.ConfigHolder;
import thedarkcolour.exdeorum.item.HammerItem;
import thedarkcolour.exdeorum.item.MeshItem;
import thedarkcolour.exdeorum.recipe.ProbabilityRecipe;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;

public class ExNihiloAPI {
    private ExNihiloAPI() {
    }

    private static Optional<Item> itemFromItemStack(ItemStack stack) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return Optional.of(stack.getItem());
        }
        return Optional.empty();
    }

    private static ItemStack getProbabilityResult(LootContext context, ProbabilityRecipe recipe, int fortune) {
        ItemStack item = recipe.result;
        int amount = recipe.resultAmount.getInt(context);
        for (int i = 0; i < fortune; ++i) {
            if (!(ThreadLocalRandom.current().nextFloat() < 0.3f)) continue;
            amount += recipe.resultAmount.getInt(context);
        }
        return item.copyWithCount(amount);
    }

    public static boolean canHammer(ItemStack stack) {
        return ExNihiloAPI.itemFromItemStack(stack).map(RecipeUtil::getHammerRecipe).isPresent();
    }

    public static List<ItemStack> getHammerResult(ServerLevel level, ItemStack stack) {
        LootContext context = RecipeUtil.emptyLootContext((ServerLevel)level);
        return ExNihiloAPI.itemFromItemStack(stack).map(RecipeUtil::getHammerRecipe).map(recipe -> ExNihiloAPI.getProbabilityResult(context, (ProbabilityRecipe)recipe, 0)).map(List::of).orElseGet(ArrayList::new);
    }

    public static boolean isMeshItem(ItemStack stack) {
        return stack.getItem() instanceof MeshItem;
    }

    public static boolean isHammerItem(ItemStack stack) {
        return stack.getItem() instanceof HammerItem;
    }

    public static boolean canSieve(ItemStack stack, ItemStack mesh, boolean waterlogged) {
        Item item = mesh.getItem();
        if (item instanceof MeshItem) {
            MeshItem meshItem = (MeshItem)item;
            return !RecipeUtil.getSieveRecipes((Item)meshItem, (ItemStack)stack).isEmpty();
        }
        return false;
    }

    public static List<ItemStack> getSieveResult(ServerLevel level, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        Item item = mesh.getItem();
        if (item instanceof MeshItem) {
            MeshItem meshItem = (MeshItem)item;
            LootContext context = RecipeUtil.emptyLootContext((ServerLevel)level);
            List recipes = RecipeUtil.getSieveRecipes((Item)meshItem, (ItemStack)stack);
            int fortune = 0;
            if (Boolean.TRUE.equals(ConfigHolder.SERVER.sieveFortuneEnabled.get())) {
                Holder.Reference holder = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE);
                fortune = mesh.getEnchantmentLevel((Holder)holder);
            }
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            for (SieveRecipe sieveRecipe : recipes) {
                output.add(ExNihiloAPI.getProbabilityResult(context, (ProbabilityRecipe)sieveRecipe, fortune));
            }
            return output;
        }
        return Collections.emptyList();
    }
}

