/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.permutated.exmachinis.components.DirectionComponent;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.buffer.ItemBufferBlock;
import net.permutated.exmachinis.machines.buffer.ItemBufferMenu;
import net.permutated.exmachinis.machines.buffer.ItemBufferTile;
import net.permutated.exmachinis.machines.compactor.FluxCompactorBlock;
import net.permutated.exmachinis.machines.compactor.FluxCompactorMenu;
import net.permutated.exmachinis.machines.compactor.FluxCompactorTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerBlock;
import net.permutated.exmachinis.machines.hammer.FluxHammerMenu;
import net.permutated.exmachinis.machines.hammer.FluxHammerTile;
import net.permutated.exmachinis.machines.sieve.FluxSieveBlock;
import net.permutated.exmachinis.machines.sieve.FluxSieveMenu;
import net.permutated.exmachinis.machines.sieve.FluxSieveTile;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.recipes.CompactingRegistry;
import net.permutated.exmachinis.util.ResourceUtil;
import net.permutated.exmachinis.util.TranslationKey;

public class ModRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"exmachinis");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"exmachinis");
    public static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"exmachinis");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"exmachinis");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"exmachinis");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"exmachinis");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"exmachinis");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"exmachinis");
    public static final Supplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)TranslationKey.tab())).icon(() -> ((Item)NETHERITE_UPGRADE.get()).getDefaultInstance()).displayItems((parameters, output) -> ITEMS.getEntries().stream().map(Supplier::get).map(Item::getDefaultInstance).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static final DeferredItem<Item> GOLD_UPGRADE = ModRegistry.upgradeItem("gold_upgrade", UpgradeItem.Tier.GOLD);
    public static final DeferredItem<Item> DIAMOND_UPGRADE = ModRegistry.upgradeItem("diamond_upgrade", UpgradeItem.Tier.DIAMOND);
    public static final DeferredItem<Item> NETHERITE_UPGRADE = ModRegistry.upgradeItem("netherite_upgrade", UpgradeItem.Tier.NETHERITE);
    public static final DeferredItem<Item> COMPARATOR_UPGRADE = ITEMS.register("comparator_upgrade", ComparatorUpgradeItem::new);
    public static final Supplier<DataComponentType<DirectionComponent>> DIRECTION_COMPONENT = COMPONENTS.registerComponentType("direction", builder -> builder.persistent(DirectionComponent.BASIC_CODEC));
    public static final DeferredBlock<Block> FLUX_SIEVE_BLOCK = BLOCKS.register("flux_sieve", FluxSieveBlock::new);
    public static final Supplier<BlockEntityType<FluxSieveTile>> FLUX_SIEVE_TILE = ModRegistry.blockEntity(FLUX_SIEVE_BLOCK, FluxSieveTile::new);
    public static final Supplier<MenuType<FluxSieveMenu>> FLUX_SIEVE_MENU = ModRegistry.container("flux_sieve", FluxSieveMenu::new);
    public static final DeferredItem<BlockItem> FLUX_SIEVE_ITEM = ModRegistry.blockItem(FLUX_SIEVE_BLOCK);
    public static final DeferredBlock<Block> FLUX_HAMMER_BLOCK = BLOCKS.register("flux_hammer", FluxHammerBlock::new);
    public static final Supplier<BlockEntityType<FluxHammerTile>> FLUX_HAMMER_TILE = ModRegistry.blockEntity(FLUX_HAMMER_BLOCK, FluxHammerTile::new);
    public static final Supplier<MenuType<FluxHammerMenu>> FLUX_HAMMER_MENU = ModRegistry.container("flux_hammer", FluxHammerMenu::new);
    public static final DeferredItem<BlockItem> FLUX_HAMMER_ITEM = ModRegistry.blockItem(FLUX_HAMMER_BLOCK);
    public static final DeferredBlock<Block> FLUX_COMPACTOR_BLOCK = BLOCKS.register("flux_compactor", FluxCompactorBlock::new);
    public static final Supplier<BlockEntityType<FluxCompactorTile>> FLUX_COMPACTOR_TILE = ModRegistry.blockEntity(FLUX_COMPACTOR_BLOCK, FluxCompactorTile::new);
    public static final Supplier<MenuType<FluxCompactorMenu>> FLUX_COMPACTOR_MENU = ModRegistry.container("flux_compactor", FluxCompactorMenu::new);
    public static final DeferredItem<BlockItem> FLUX_COMPACTOR_ITEM = ModRegistry.blockItem(FLUX_COMPACTOR_BLOCK);
    public static final Supplier<RecipeType<CompactingRecipe>> COMPACTING_RECIPE_TYPE = RECIPE_TYPES.register("compacting", () -> RecipeType.simple((ResourceLocation)ResourceUtil.prefix("compacting")));
    public static final Supplier<RecipeSerializer<CompactingRecipe>> COMPACTING_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("compacting", CompactingRecipe.Serializer::new);
    public static final CompactingRegistry COMPACTING_REGISTRY = new CompactingRegistry();
    public static final DeferredBlock<Block> ITEM_BUFFER_BLOCK = BLOCKS.register("item_buffer", ItemBufferBlock::new);
    public static final Supplier<BlockEntityType<ItemBufferTile>> ITEM_BUFFER_TILE = ModRegistry.blockEntity(ITEM_BUFFER_BLOCK, ItemBufferTile::new);
    public static final Supplier<MenuType<ItemBufferMenu>> ITEM_BUFFER_MENU = ModRegistry.container("item_buffer", ItemBufferMenu::new);
    public static final DeferredItem<BlockItem> ITEM_BUFFER_ITEM = ModRegistry.blockItem(ITEM_BUFFER_BLOCK);
    public static final TagKey<Item> SIEVES = ItemTags.create((ResourceLocation)ResourceUtil.prefix("sieves"));
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static DeferredItem<BlockItem> blockItem(DeferredBlock<Block> registryObject) {
        return ITEMS.register(registryObject.getId().getPath(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
    }

    public static DeferredItem<Item> upgradeItem(String name, UpgradeItem.Tier tier) {
        return ITEMS.register(name, () -> new UpgradeItem(tier));
    }

    private static <T extends AbstractMachineTile> Supplier<BlockEntityType<T>> blockEntity(DeferredBlock<Block> registryObject, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return TILES.register(registryObject.getId().getPath(), () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)registryObject.get()}).build(EMPTY_PART));
    }

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IMenuTypeExtension.create((IContainerFactory)supplier));
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        COMPONENTS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
        RECIPE_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        CREATIVE_TABS.register(bus);
    }
}

