/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.config.ServerConfig;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.util.StringRepresentable;

public enum SpikeMaterial implements StringRepresentable
{
    WOOD("wood", 0, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).woodenSpikeDamage),
    STONE("stone", 1, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).stoneSpikeDamage),
    IRON("iron", 2, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).ironSpikeDamage),
    GOLD("gold", 3, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).goldenSpikeDamage),
    DIAMOND("diamond", 4, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).diamondSpikeDamage),
    NETHERITE("netherite", 5, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).netheriteSpikeDamage);

    public static final StringRepresentable.StringRepresentableCodec<SpikeMaterial> CODEC;
    private final String materialName;
    private final int materialTier;
    private final DoubleSupplier damageAmount;

    private SpikeMaterial(String materialName, int materialTier, DoubleSupplier damageAmount) {
        this.materialName = materialName;
        this.materialTier = materialTier;
        this.damageAmount = damageAmount;
    }

    public float damageAmount() {
        return (float)this.damageAmount.getAsDouble();
    }

    public ChatFormatting getTooltipStyle() {
        ChatFormatting chatFormatting;
        Double d = this.damageAmount.getAsDouble();
        Objects.requireNonNull(d);
        Double d2 = d;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Double.class}, (Object)d2, n)) {
                case 0: {
                    Double d3 = d2;
                    if (!(d3 >= 8.0)) {
                        n = 1;
                        continue block4;
                    }
                    chatFormatting = ChatFormatting.GREEN;
                    break block4;
                }
                case 1: {
                    Double d4 = d2;
                    if (!(d4 >= 4.0)) {
                        n = 2;
                        continue block4;
                    }
                    chatFormatting = ChatFormatting.AQUA;
                    break block4;
                }
                default: {
                    chatFormatting = ChatFormatting.RED;
                    break block4;
                }
            }
            break;
        }
        return chatFormatting;
    }

    public boolean dealsFinalBlow() {
        return this.isAtLeast(STONE);
    }

    public boolean dropsMobLoot() {
        return this.isAtLeast(IRON) && this != GOLD;
    }

    public boolean dropsExperience() {
        return this.isAtLeast(GOLD);
    }

    public boolean dropsPlayerLoot() {
        return this.isAtLeast(DIAMOND);
    }

    public boolean hurtsPlayers() {
        return this != NETHERITE;
    }

    private boolean isAtLeast(SpikeMaterial material) {
        return this.materialTier >= material.materialTier;
    }

    public String getSerializedName() {
        return this.materialName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(SpikeMaterial::values);
    }
}

