/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.mixin.accessor.LivingEntityAccessor;
import fuzs.spikyspikes.world.damagesource.SpikeDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import fuzs.spikyspikes.world.phys.shapes.VoxelUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpikeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SpikeBlock> CODEC = SpikeBlock.spikeCodec(SpikeBlock::new);
    public static final DecimalFormat TOOLTIP_DAMAGE_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("0.0"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), SpikeBlock::makeVisualShape));
    private static final Map<Direction, VoxelShape> COLLISION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, false)));
    private static final Map<Direction, VoxelShape> INTERACTION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, true)));
    public final SpikeMaterial spikeMaterial;

    public SpikeBlock(SpikeMaterial spikeMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.spikeMaterial = spikeMaterial;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected static <T extends SpikeBlock> MapCodec<T> spikeCodec(BiFunction<SpikeMaterial, BlockBehaviour.Properties, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpikeMaterial.CODEC.fieldOf("material").forGetter(SpikeBlock::getSpikeMaterial), (App)SpikeBlock.propertiesCodec()).apply((Applicative)instance, factory));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public SpikeMaterial getSpikeMaterial() {
        return this.spikeMaterial;
    }

    private static VoxelShape makeVisualShape(Direction direction) {
        VoxelShape shape = SpikeBlock.makeStaircasePyramid(direction, 8, 2.0);
        Vec3[] outlineVectors = VoxelUtils.makePyramidEdges(VoxelUtils.makeVectors(0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 16.0, 0.0, 16.0, 0.0, 0.0, 16.0, 8.0, 16.0, 8.0));
        return new CustomOutlineShape(shape, VoxelUtils.scale(VoxelUtils.rotate(direction, outlineVectors)));
    }

    private static VoxelShape makeStaircasePyramid(Direction direction, int layers, double layerHeight) {
        Vec3[] vectors = new Vec3[layers * 2];
        int i = 0;
        int j = layers;
        while (i < layers) {
            vectors[2 * i] = new Vec3(8.0 - (double)j, (double)i * layerHeight, 8.0 - (double)j);
            vectors[2 * i + 1] = new Vec3(8.0 + (double)j, (double)(i + 1) * layerHeight, 8.0 + (double)j);
            ++i;
            --j;
        }
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    private static VoxelShape makeCollisionShape(Direction direction, boolean fullHeight) {
        Vec3[] vectors = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, fullHeight ? 16.0 : 11.0, 15.0);
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return SHAPE_BY_DIRECTION.get(blockState.getValue((Property)FACING));
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return COLLISION_SHAPE_BY_DIRECTION.get(blockState.getValue((Property)FACING));
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.getShape(blockState, level, blockPos, context);
    }

    public VoxelShape getInteractionShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return INTERACTION_SHAPE_BY_DIRECTION.get(blockState.getValue((Property)FACING));
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(direction.getOpposite());
        if (direction == Direction.UP) {
            return SpikeBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)otherPos);
        }
        return level.getBlockState(otherPos).isFaceSturdy((BlockGetter)level, otherPos, direction);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction == ((Direction)blockState.getValue((Property)FACING)).getOpposite() && !blockState.canSurvive((LevelReader)level, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, neighborState, level, blockPos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        for (Direction direction : context.getNearestLookingDirections()) {
            Direction opposite = direction.getOpposite();
            if (!(state = (BlockState)state.setValue((Property)FACING, (Comparable)opposite)).canSurvive((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block10: {
            LivingEntity livingEntity;
            block11: {
                if (level.isClientSide || !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive() || livingEntity.getType().is(ModRegistry.SPIKE_DAMAGE_IMMUNE_ENTITY_TYPE_TAG)) break block10;
                if (!(livingEntity instanceof Player)) break block11;
                Player player = (Player)livingEntity;
                if (player.getAbilities().instabuild || player.getAbilities().invulnerable) break block10;
            }
            if ((this.spikeMaterial.dealsFinalBlow() || livingEntity.getHealth() > this.spikeMaterial.damageAmount()) && (this.spikeMaterial.hurtsPlayers() || !(livingEntity instanceof Player))) {
                if (this.spikeMaterial.dropsPlayerLoot()) {
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof SpikeBlockEntity) {
                        SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
                        SpikeBlockEntity.attack((ServerLevel)level, pos, level.getBlockState(pos), blockEntity2, livingEntity, this.spikeMaterial);
                    }
                } else {
                    boolean doMobLoot = level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(false, level.getServer());
                    }
                    livingEntity.hurt(SpikeDamageSource.source(ModRegistry.SPIKE_DAMAGE_TYPE, level, pos), this.spikeMaterial.damageAmount());
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(doMobLoot, level.getServer());
                    }
                    if (!livingEntity.isAlive() && this.spikeMaterial.dropsExperience()) {
                        ((LivingEntityAccessor)livingEntity).spikyspikes$setLastHurtByPlayerTime(100);
                        ((LivingEntityAccessor)livingEntity).spikyspikes$callDropExperience(null);
                        livingEntity.skipDropExperience();
                    }
                }
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpikeBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
        if (context != Item.TooltipContext.EMPTY) {
            if (!Proxy.INSTANCE.hasShiftDown()) {
                tooltipComponents.add((Component)Component.translatable((String)"item.spikyspikes.spike.tooltip.more", (Object[])new Object[]{Component.translatable((String)"item.spikyspikes.spike.tooltip.shift").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines((Component)Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GRAY)));
                tooltipComponents.add((Component)Component.translatable((String)"item.spikyspikes.spike.tooltip.damage", (Object[])new Object[]{Component.translatable((String)"item.spikyspikes.spike.tooltip.hearts", (Object[])new Object[]{Component.literal((String)String.valueOf(TOOLTIP_DAMAGE_FORMAT.format(this.spikeMaterial.damageAmount() / 2.0f)))}).withStyle(this.spikeMaterial.getTooltipStyle())}).withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity;
        ItemStack itemStack = super.getCloneItemStack(level, pos, blockState);
        if (this.spikeMaterial.dropsPlayerLoot() && (blockEntity = level.getBlockEntity(pos)) instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
            itemStack.applyComponents(blockEntity2.collectComponents());
        }
        return itemStack;
    }
}

