/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block.entity.client;

import com.benbenlaw.routers.block.ExporterBlock;
import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.ExporterBlockEntity;
import com.benbenlaw.routers.util.RoutersTags;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ExporterBlockEntityRenderer
implements BlockEntityRenderer<ExporterBlockEntity> {
    private static final RenderType NO_CULL_BEAM = RenderType.create((String)"no_cull_beam", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_BEACON_BEAM_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png"), false, false)).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setCullState(RenderType.NO_CULL).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.NO_OVERLAY).createCompositeState(false));

    public ExporterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRender(ExporterBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public boolean shouldRenderOffScreen(ExporterBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 32;
    }

    public AABB getRenderBoundingBox(ExporterBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(32.0);
    }

    public void render(ExporterBlockEntity exporter, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).is(Tags.Items.TOOLS_WRENCH)) {
            return;
        }
        Level level = exporter.getLevel();
        if (level == null) {
            return;
        }
        List<BlockPos> importerPositions = exporter.getImporterPositions();
        Vec3 exporterPos = this.getBeamStart(exporter.getBlockPos(), level);
        ItemStackHandler handler = exporter.getItemStackHandler();
        HashSet<CallSite> uniqueKeys = new HashSet<CallSite>();
        ArrayList<float[]> uniqueColors = new ArrayList<float[]>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            String key;
            ItemStack stack = handler.getStackInSlot(slot);
            float[] tint = this.getBeamTint(stack);
            if (tint[0] == 0.0f && tint[1] == 0.0f && tint[2] == 0.0f || uniqueKeys.contains(key = tint[0] + "," + tint[1] + "," + tint[2])) continue;
            uniqueKeys.add((CallSite)((Object)key));
            uniqueColors.add(tint);
        }
        if (uniqueColors.isEmpty()) {
            return;
        }
        for (BlockPos importerPosRaw : importerPositions) {
            Vec3 up;
            Vec3 importerPos = this.getBeamStart(importerPosRaw, level);
            Vec3 delta = importerPos.subtract(exporterPos);
            double length = delta.length();
            Vec3 dir = delta.normalize();
            Vec3 perp = dir.cross(up = new Vec3(0.0, 1.0, 0.0));
            if (perp.lengthSqr() < 1.0E-6) {
                perp = dir.cross(new Vec3(1.0, 0.0, 0.0));
            }
            perp = perp.normalize();
            Vec3 side = dir.cross(perp).normalize();
            int count = uniqueColors.size();
            double radius = 0.03;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)count;
                Vec3 offset = perp.scale(Math.cos(angle) * radius).add(side.scale(Math.sin(angle) * radius));
                Vec3 startPos = exporterPos.add(offset);
                float[] tint = (float[])uniqueColors.get(i);
                this.renderSingleBeam(poseStack, bufferSource, startPos, dir, length, packedLight, packedOverlay, tint[0], tint[1], tint[2]);
            }
        }
    }

    private void renderSingleBeam(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 startPos, Vec3 dir, double length, int light, int overlay, float r, float g, float b) {
        float a = 1.0f;
        float beamRadius = 0.0075f;
        float time = (float)(System.currentTimeMillis() % 10000L) / 10000.0f;
        float vOffset = -(time * 2.0f);
        poseStack.pushPose();
        poseStack.translate(startPos.x - Math.floor(startPos.x), startPos.y - Math.floor(startPos.y), startPos.z - Math.floor(startPos.z));
        Vector3f from = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f to = new Vector3f((float)dir.x, (float)dir.y, (float)dir.z);
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)from, (Vector3fc)to);
        poseStack.mulPose(rotation);
        VertexConsumer consumer = bufferSource.getBuffer(NO_CULL_BEAM);
        for (int i = 0; i < 4; ++i) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees((float)i * 90.0f));
            PoseStack.Pose pose = poseStack.last();
            ExporterBlockEntityRenderer.addBeamVertex(consumer, pose, -beamRadius, 0.0f, -beamRadius, r, g, b, a, 0.0f, vOffset, light, overlay);
            ExporterBlockEntityRenderer.addBeamVertex(consumer, pose, beamRadius, 0.0f, -beamRadius, r, g, b, a, 1.0f, vOffset, light, overlay);
            ExporterBlockEntityRenderer.addBeamVertex(consumer, pose, beamRadius, (float)length, -beamRadius, r, g, b, a, 1.0f, vOffset + (float)length, light, overlay);
            ExporterBlockEntityRenderer.addBeamVertex(consumer, pose, -beamRadius, (float)length, -beamRadius, r, g, b, a, 0.0f, vOffset + (float)length, light, overlay);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static void addBeamVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light, int overlay) {
        consumer.addVertex(pose, x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private Vec3 getBeamStart(BlockPos pos, Level level) {
        BlockState state = level.getBlockState(pos);
        Direction facing = state.hasProperty((Property)ExporterBlock.FACING) ? (Direction)state.getValue((Property)ExporterBlock.FACING) : (state.hasProperty((Property)ImporterBlock.FACING) ? (Direction)state.getValue((Property)ImporterBlock.FACING) : Direction.UP);
        VoxelShape shape = state.getShape((BlockGetter)level, pos, CollisionContext.empty());
        double x = 0.5;
        double y = 0.0;
        double z = 0.5;
        for (AABB box : shape.toAabbs()) {
            switch (facing) {
                case UP: {
                    x = (box.minX + box.maxX) / 2.0;
                    y = box.maxY;
                    z = (box.minZ + box.maxZ) / 2.0;
                    break;
                }
                case DOWN: {
                    x = (box.minX + box.maxX) / 2.0;
                    y = box.minY;
                    z = (box.minZ + box.maxZ) / 2.0;
                    break;
                }
                case NORTH: {
                    x = (box.minX + box.maxX) / 2.0;
                    y = (box.minY + box.maxY) / 2.0;
                    z = box.minZ;
                    break;
                }
                case SOUTH: {
                    x = (box.minX + box.maxX) / 2.0;
                    y = (box.minY + box.maxY) / 2.0;
                    z = box.maxZ;
                    break;
                }
                case WEST: {
                    x = box.minX;
                    y = (box.minY + box.maxY) / 2.0;
                    z = (box.minZ + box.maxZ) / 2.0;
                    break;
                }
                case EAST: {
                    x = box.maxX;
                    y = (box.minY + box.maxY) / 2.0;
                    z = (box.minZ + box.maxZ) / 2.0;
                }
            }
        }
        if (y <= 0.0) {
            y = 0.1875;
        }
        return new Vec3((double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z);
    }

    private float[] getBeamTint(ItemStack stack) {
        if (stack.isEmpty()) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        if (stack.is(RoutersTags.Items.RF_UPGRADES)) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        if (stack.is(RoutersTags.Items.ITEM_UPGRADES)) {
            return new float[]{0.0f, 0.0f, 1.0f};
        }
        if (stack.is(RoutersTags.Items.FLUID_UPGRADES)) {
            return new float[]{1.0f, 1.0f, 0.0f};
        }
        if (stack.is(RoutersTags.Items.CHEMICAL_UPGRADES)) {
            return new float[]{1.0f, 0.0f, 1.0f};
        }
        if (stack.is(RoutersTags.Items.SOUL_UPGRADES)) {
            return new float[]{0.0f, 1.0f, 1.0f};
        }
        if (stack.is(RoutersTags.Items.SOURCE_UPGRADES)) {
            return new float[]{0.5f, 1.0f, 1.0f};
        }
        if (stack.is(RoutersTags.Items.PRESSURE_UPGRADES)) {
            return new float[]{1.0f, 0.5f, 0.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }
}

