/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.neoforge.client.gui;

import de.nekeras.borderless.neoforge.client.BorderlessWindowClient;
import de.nekeras.borderless.neoforge.client.config.Config;
import de.nekeras.borderless.neoforge.client.config.FocusLossConfig;
import de.nekeras.borderless.neoforge.client.config.FullscreenModeConfig;
import de.nekeras.borderless.neoforge.client.gui.ConfigScreenOption;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private static final String DESCRIPTION_KEY_BASE = "borderless.%s";
    private static final int LAYOUT_MAX_WIDTH = 250;
    private static final int WHITE = 0xFFFFFF;
    private static final int YELLOW = 0xFFFF00;
    private static final int RED = 0xFF0000;
    private static final int LINE_HEIGHT = 25;
    private static final Component titleText = Component.translatable((String)"borderless.config.title");
    private static final Component applyText = Component.translatable((String)"borderless.config.apply");
    private static final Component changedWarningText = Component.translatable((String)"borderless.config.changed");
    private static final Component disabledText = Component.translatable((String)"borderless.config.disabled.description");
    private static final Logger log = LogManager.getLogger();
    private final Screen parent;
    private AbstractWidget enabledButton;
    private AbstractWidget fullscreenModeButton;
    private AbstractWidget focusLossButton;

    public ConfigScreen(@Nonnull Screen parent) {
        super(titleText);
        this.parent = parent;
    }

    protected void init() {
        super.init();
        boolean initialEnabledState = (Boolean)Config.GENERAL.enabled.get();
        FullscreenModeConfig initialFullscreenMode = (FullscreenModeConfig)((Object)Config.GENERAL.fullscreenMode.get());
        FocusLossConfig initialFocusLossMode = (FocusLossConfig)((Object)Config.GENERAL.focusLoss.get());
        Minecraft minecraft = Minecraft.getInstance();
        int x = this.getHorizontalLayoutStart(this.width);
        this.enabledButton = ConfigScreenOption.enabled.createButton(minecraft.options, x, 25, 250);
        this.fullscreenModeButton = ConfigScreenOption.fullscreenMode.createButton(minecraft.options, x, 50, 250);
        this.focusLossButton = ConfigScreenOption.focusLoss.createButton(minecraft.options, x, 75, 250);
        Button applyButton = Button.builder((Component)applyText, btn -> {
            log.info("Apply button in Borderless Window Config Screen pressed");
            BorderlessWindowClient.getDisplayModeHolder().setFullscreenDisplayModeFromConfig();
            this.onClose();
        }).bounds(this.width / 2 - 125, this.height - 75, 100, 20).build();
        Button cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, btn -> {
            log.info("Cancel button in Borderless Window Config Screen pressed, resetting to {}, {}, {}", (Object)initialEnabledState, (Object)initialFullscreenMode, (Object)initialFocusLossMode);
            Config.GENERAL.enabled.set((Object)initialEnabledState);
            Config.GENERAL.fullscreenMode.set((Object)initialFullscreenMode);
            Config.GENERAL.focusLoss.set((Object)initialFocusLossMode);
            this.onClose();
        }).bounds(this.width / 2 + 25, this.height - 75, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.enabledButton);
        this.addRenderableWidget((GuiEventListener)this.fullscreenModeButton);
        this.addRenderableWidget((GuiEventListener)this.focusLossButton);
        this.addRenderableWidget((GuiEventListener)applyButton);
        this.addRenderableWidget((GuiEventListener)cancelButton);
        this.refreshButtonStates();
    }

    public void tick() {
        super.tick();
        this.refreshButtonStates();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float frameTime) {
        Minecraft minecraft = Minecraft.getInstance();
        this.renderBackground(guiGraphics, mouseX, mouseY, frameTime);
        super.render(guiGraphics, mouseX, mouseY, frameTime);
        this.renderTitle(guiGraphics, minecraft, this.width);
        this.renderDescription(guiGraphics, minecraft, this.width);
        this.renderChangedWarning(guiGraphics, minecraft, this.width, this.height);
    }

    public void onClose() {
        super.onClose();
        Minecraft.getInstance().setScreen(this.parent);
    }

    private void renderTitle(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width) {
        guiGraphics.drawCenteredString(minecraft.font, this.title, width / 2, 10, 0xFFFFFF);
    }

    private void renderDescription(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width) {
        int x = this.getHorizontalLayoutStart(width);
        int y = 100;
        if (((Boolean)Config.GENERAL.enabled.get()).booleanValue()) {
            guiGraphics.drawWordWrap(minecraft.font, (FormattedText)Component.translatable((String)this.getDescriptionKey()), x, y, 250, 0xFFFFFF);
        } else {
            guiGraphics.drawWordWrap(minecraft.font, (FormattedText)disabledText, x, y, 250, 0xFF0000);
        }
    }

    private void renderChangedWarning(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width, int height) {
        int x = this.getHorizontalLayoutStart(width);
        int y = height - 50;
        guiGraphics.drawWordWrap(minecraft.font, (FormattedText)changedWarningText, x, y, 250, 0xFFFF00);
    }

    private String getDescriptionKey() {
        FullscreenModeConfig mode = (FullscreenModeConfig)((Object)Config.GENERAL.fullscreenMode.get());
        String modeKey = String.format(DESCRIPTION_KEY_BASE, mode.name().toLowerCase());
        if (mode == FullscreenModeConfig.NATIVE) {
            FocusLossConfig focusLoss = (FocusLossConfig)((Object)Config.GENERAL.focusLoss.get());
            return String.format("%s.%s", modeKey, focusLoss.name().toLowerCase());
        }
        return modeKey;
    }

    private void refreshButtonStates() {
        boolean enabled = (Boolean)Config.GENERAL.enabled.get();
        this.enabledButton.visible = true;
        this.fullscreenModeButton.visible = enabled;
        this.focusLossButton.visible = enabled && Config.GENERAL.fullscreenMode.get() == FullscreenModeConfig.NATIVE;
    }

    private int getHorizontalLayoutStart(int width) {
        return (width - 250) / 2;
    }
}

