/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.neoforge.client.config;

import de.nekeras.borderless.common.DesktopEnvironment;
import de.nekeras.borderless.common.mode.FullscreenDisplayMode;
import de.nekeras.borderless.neoforge.client.config.FocusLossConfig;
import de.nekeras.borderless.neoforge.client.config.FullscreenModeConfig;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final String GENERAL_PATH = "general";
    private static final String ENABLED_PATH = "enabled";
    private static final String FULLSCREEN_MODE_PATH = "fullscreenMode";
    private static final String FOCUS_LOSS_PATH = "focusLoss";
    private static final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    public static final General GENERAL = new General(builder);
    public static final ModConfigSpec CONFIG_SPEC = builder.build();

    @Nonnull
    public static FullscreenDisplayMode getFullscreenDisplayMode() {
        if (Boolean.TRUE.equals(Config.GENERAL.enabled.get())) {
            return switch ((FullscreenModeConfig)((Object)Config.GENERAL.fullscreenMode.get())) {
                default -> throw new MatchException(null, null);
                case FullscreenModeConfig.BEST -> DesktopEnvironment.get().getBestFullscreenDisplayMode();
                case FullscreenModeConfig.BORDERLESS -> FullscreenDisplayMode.BORDERLESS;
                case FullscreenModeConfig.NATIVE -> {
                    switch ((FocusLossConfig)((Object)Config.GENERAL.focusLoss.get())) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case MINIMIZE: {
                            yield FullscreenDisplayMode.NATIVE;
                        }
                        case DO_NOTHING: {
                            yield FullscreenDisplayMode.NATIVE_NON_ICONIFY;
                        }
                        case SWITCH_TO_WINDOWED: 
                    }
                    yield FullscreenDisplayMode.NATIVE_SWITCH_TO_WINDOWED;
                }
            };
        }
        return FullscreenDisplayMode.NATIVE;
    }

    public static class General {
        public final ModConfigSpec.BooleanValue enabled;
        public final ModConfigSpec.EnumValue<FullscreenModeConfig> fullscreenMode;
        public final ModConfigSpec.EnumValue<FocusLossConfig> focusLoss;

        public General(ModConfigSpec.Builder builder) {
            builder.push(Config.GENERAL_PATH);
            this.enabled = builder.define(Config.ENABLED_PATH, true);
            this.fullscreenMode = builder.comment((String[])Arrays.stream(FullscreenModeConfig.values()).map(mode -> String.format("%s - %s", mode.name(), mode.getComment())).toArray(String[]::new)).defineEnum(Config.FULLSCREEN_MODE_PATH, (Enum)FullscreenModeConfig.BEST);
            this.focusLoss = builder.comment((String[])Arrays.stream(FocusLossConfig.values()).map(mode -> String.format("%s - %s", mode.name(), mode.getComment())).toArray(String[]::new)).defineEnum(Config.FOCUS_LOSS_PATH, (Enum)FocusLossConfig.MINIMIZE);
            builder.pop();
        }
    }
}

