/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common.mode;

import de.nekeras.borderless.common.glfw.GlfwUtils;
import de.nekeras.borderless.common.glfw.GlfwWindowAttribute;
import de.nekeras.borderless.common.mode.FullscreenDisplayMode;
import de.nekeras.borderless.common.spi.MinecraftMonitor;
import de.nekeras.borderless.common.spi.MinecraftVideoMode;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderlessFullscreenDisplay
implements FullscreenDisplayMode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BorderlessFullscreenDisplay.class);

    @Override
    public void apply(@Nonnull MinecraftWindow window) {
        FullscreenDisplayMode.super.apply(window);
        MinecraftMonitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
        if (monitor == null) {
            log.error("Window's monitor could not be retrieved");
        } else {
            MinecraftVideoMode videoMode = monitor.getCurrentMode();
            String name = GlfwUtils.getMonitorName(monitor);
            int x = monitor.getX();
            int y = monitor.getY();
            int width = videoMode.getWidth();
            int height = videoMode.getHeight();
            log.info("Apply on monitor {} at ({}|{}) size ({} x {})", new Object[]{name, x, y, width, height});
            GlfwUtils.disableWindowAttribute(window, GlfwWindowAttribute.DECORATED);
            GLFW.glfwSetWindowMonitor((long)window.getHandle(), (long)0L, (int)x, (int)y, (int)width, (int)height, (int)-1);
        }
    }

    @Override
    public void reset(@Nonnull MinecraftWindow window) {
        FullscreenDisplayMode.super.reset(window);
        if (window.isFullscreen()) {
            MinecraftMonitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
            if (monitor == null) {
                log.error("Window's monitor could not be retrieved");
            } else {
                MinecraftVideoMode videoMode = monitor.getCurrentMode();
                String name = GlfwUtils.getMonitorName(monitor);
                int width = videoMode.getWidth();
                int height = videoMode.getHeight();
                log.info("Reset on monitor {} at size ({} x {})", new Object[]{name, width, height});
                GLFW.glfwSetWindowMonitor((long)window.getHandle(), (long)monitor.getHandle(), (int)0, (int)0, (int)width, (int)height, (int)-1);
            }
        }
    }
}

