/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common;

import de.nekeras.borderless.common.mode.FullscreenDisplayMode;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DesktopEnvironment {
    WINDOWS(FullscreenDisplayMode.BORDERLESS),
    X11(FullscreenDisplayMode.NATIVE_NON_ICONIFY),
    WAYLAND(FullscreenDisplayMode.NATIVE_NON_ICONIFY),
    GENERIC(FullscreenDisplayMode.NATIVE);

    @Generated
    private static final Logger log;
    private static final String LINUX_WINDOW_SYSTEM_VARIABLE = "XDG_SESSION_TYPE";
    private static final String X11_NAME = "x11";
    private static final String WAYLAND_NAME = "wayland";
    private static final DesktopEnvironment CURRENT;
    private final FullscreenDisplayMode bestFullscreenDisplayMode;

    private DesktopEnvironment(FullscreenDisplayMode bestFullscreenDisplayMode) {
        this.bestFullscreenDisplayMode = bestFullscreenDisplayMode;
    }

    @Nonnull
    public FullscreenDisplayMode getBestFullscreenDisplayMode() {
        return this.bestFullscreenDisplayMode;
    }

    @Nonnull
    public static DesktopEnvironment get() {
        return CURRENT;
    }

    static {
        log = LoggerFactory.getLogger(DesktopEnvironment.class);
        log.info("Determining desktop environment");
        DesktopEnvironment current = null;
        switch (Platform.get()) {
            case WINDOWS: {
                current = WINDOWS;
                break;
            }
            case LINUX: {
                String result = System.getenv(LINUX_WINDOW_SYSTEM_VARIABLE);
                if (X11_NAME.equalsIgnoreCase(result)) {
                    current = X11;
                    break;
                }
                if (WAYLAND_NAME.equalsIgnoreCase(result)) {
                    current = WAYLAND;
                    break;
                }
                current = GENERIC;
                log.warn("Unknown window system: {}", (Object)result);
                break;
            }
            case MACOSX: {
                current = GENERIC;
            }
        }
        CURRENT = current;
        log.info("Found desktop environment {}", (Object)CURRENT);
    }
}

