/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crucible;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import thedarkcolour.exdeorum.recipe.CodecUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public abstract class CrucibleRecipe
extends SingleIngredientRecipe {
    private final FluidStack result;

    protected CrucibleRecipe(Ingredient ingredient, FluidStack result) {
        super(ingredient);
        this.result = result;
        if (this.dependsOnNbt) {
            throw new IllegalArgumentException("Cannot use NBT to determine Ex Deorum Crucible output");
        }
    }

    public FluidStack getResult() {
        return this.result;
    }

    private static <R extends CrucibleRecipe> MapCodec<R> mapCodec(BiFunction<Ingredient, FluidStack, R> factory) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group(CodecUtil.ingredientField(), (App)CodecUtil.FLUIDSTACK_CODEC.fieldOf("fluid").forGetter(CrucibleRecipe::getResult)).apply((Applicative)instance, factory));
    }

    private static <R extends CrucibleRecipe> StreamCodec<RegistryFriendlyByteBuf, R> streamCodec(BiFunction<Ingredient, FluidStack, R> factory) {
        return StreamCodec.of(CrucibleRecipe::toNetwork, buffer -> (CrucibleRecipe)factory.apply((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), (FluidStack)FluidStack.STREAM_CODEC.decode(buffer)));
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, CrucibleRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
    }

    public record Serializer<R extends CrucibleRecipe>(MapCodec<R> recipeCodec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec) implements RecipeSerializer<R>
    {
        public MapCodec<R> codec() {
            return this.recipeCodec;
        }
    }

    public static class Water
    extends CrucibleRecipe {
        public static final MapCodec<Water> CODEC = CrucibleRecipe.mapCodec(Water::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, Water> STREAM_CODEC = CrucibleRecipe.streamCodec(Water::new);

        public Water(Ingredient ingredient, FluidStack result) {
            super(ingredient, result);
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)ERecipeSerializers.WATER_CRUCIBLE.get();
        }

        public RecipeType<?> getType() {
            return (RecipeType)ERecipeTypes.WATER_CRUCIBLE.get();
        }
    }

    public static class Lava
    extends CrucibleRecipe {
        public static final MapCodec<Lava> CODEC = CrucibleRecipe.mapCodec(Lava::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, Lava> STREAM_CODEC = CrucibleRecipe.streamCodec(Lava::new);

        public Lava(Ingredient ingredient, FluidStack result) {
            super(ingredient, result);
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)ERecipeSerializers.LAVA_CRUCIBLE.get();
        }

        public RecipeType<?> getType() {
            return (RecipeType)ERecipeTypes.LAVA_CRUCIBLE.get();
        }
    }
}

