/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;

public class SingleIngredientRecipeCache<T extends SingleIngredientRecipe> {
    private final Supplier<RecipeType<T>> recipeType;
    private RecipeManager recipeManager;
    @Nullable
    private Map<Item, T> simpleRecipes;
    @Nullable
    private List<T> complexRecipes;
    @Nullable
    private Collection<RecipeHolder<T>> allRecipes;
    private boolean trackAllRecipes;

    public SingleIngredientRecipeCache(RecipeManager recipeManager, Supplier<RecipeType<T>> recipeType) {
        this.recipeType = recipeType;
        this.recipeManager = recipeManager;
    }

    public SingleIngredientRecipeCache<T> trackAllRecipes() {
        this.trackAllRecipes = true;
        return this;
    }

    @Nullable
    public T getRecipe(Item item) {
        return this.getRecipe(new ItemStack((ItemLike)item));
    }

    @Nullable
    public T getRecipe(ItemStack item) {
        SingleIngredientRecipe recipe;
        if (this.simpleRecipes == null) {
            this.buildRecipes();
        }
        if ((recipe = (SingleIngredientRecipe)this.simpleRecipes.get(item.getItem())) == null && this.complexRecipes != null) {
            for (SingleIngredientRecipe complexRecipe : this.complexRecipes) {
                if (!complexRecipe.ingredient().test(item)) continue;
                return (T)complexRecipe;
            }
            return null;
        }
        return (T)recipe;
    }

    public Collection<RecipeHolder<T>> getAllRecipes() {
        if (this.simpleRecipes == null) {
            this.buildRecipes();
        }
        return this.allRecipes;
    }

    private void buildRecipes() {
        this.simpleRecipes = new HashMap<Item, T>();
        ImmutableList.Builder complexRecipes = ImmutableList.builder();
        Collection allRecipes = this.recipeManager.byType(this.recipeType.get());
        for (RecipeHolder holder : allRecipes) {
            SingleIngredientRecipe recipe = (SingleIngredientRecipe)holder.value();
            Ingredient ingredient = recipe.ingredient();
            if (ingredient.isSimple()) {
                for (ItemStack item : ingredient.getItems()) {
                    this.simpleRecipes.put(item.getItem(), recipe);
                }
                continue;
            }
            complexRecipes.add((Object)recipe);
        }
        this.complexRecipes = complexRecipes.build();
        if (this.complexRecipes.isEmpty()) {
            this.complexRecipes = null;
        }
        if (this.trackAllRecipes) {
            this.allRecipes = allRecipes;
        }
        this.recipeManager = null;
    }
}

