/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.client.ClientHandler;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;
import thedarkcolour.exdeorum.network.MenuPropertyMessage;
import thedarkcolour.exdeorum.network.VisualUpdateMessage;

public class ClientMessageHandler {
    public static void handleVoidWorldMessage(IPayloadContext ctx) {
        ctx.enqueueWork(ClientHandler::disableVoidFogRendering);
    }

    static void handleVisualUpdate(VisualUpdateMessage msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity patt0$temp;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (patt0$temp = level.getBlockEntity(msg.pos())) instanceof EBlockEntity) {
                EBlockEntity blockEntity = (EBlockEntity)patt0$temp;
                if (msg.payload() == null) {
                    if (blockEntity != msg.blockEntity() && msg.blockEntity() != null) {
                        blockEntity.copyVisualData(msg.blockEntity());
                    } else {
                        ExDeorum.LOGGER.warn("Failed syncing visual data from server for " + msg.pos().toShortString());
                    }
                } else {
                    blockEntity.readVisualData(msg.payload());
                }
            }
        });
    }

    public static void handleMenuProperty(MenuPropertyMessage msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (patt0$temp = player.containerMenu) instanceof AbstractMachineMenu) {
                AbstractMachineMenu menu = (AbstractMachineMenu)patt0$temp;
                if (menu.containerId == msg.containerId()) {
                    menu.setClientProperty(msg.index(), msg.value());
                }
            }
        });
    }
}

