/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.MechanicalSieveBlockEntity;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;
import thedarkcolour.exdeorum.registry.EMenus;

public class MechanicalSieveMenu
extends AbstractMachineMenu<MechanicalSieveBlockEntity> {
    private static final ResourceLocation EMPTY_SLOT_MESH = ExDeorum.loc("item/empty_slot_mesh");
    private static final int NUM_SLOTS = 22;

    public MechanicalSieveMenu(int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(containerId, playerInventory, (MechanicalSieveBlockEntity)MechanicalSieveMenu.readPayload(playerInventory, data));
    }

    public MechanicalSieveMenu(int containerId, Inventory playerInventory, MechanicalSieveBlockEntity sieve) {
        super((MenuType)EMenus.MECHANICAL_SIEVE.get(), containerId, playerInventory, sieve);
        this.addSlot((Slot)sieve.inventory.createSlot(0, 26, 30));
        this.addSlot(sieve.inventory.createSlot(1, 26, 53).setBackground(InventoryMenu.BLOCK_ATLAS, EMPTY_SLOT_MESH));
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 5; ++c) {
                this.addSlot((Slot)sieve.inventory.createSlot(2 + r * 5 + c, 80 + c * 18, 15 + r * 18));
            }
        }
        this.addPlayerSlots(playerInventory, 91);
    }

    public ItemStack quickMoveStack(Player player, int clickedSlot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(clickedSlot);
        if (slot.hasItem()) {
            ItemStack clickedStack = slot.getItem();
            stack = clickedStack.copy();
            if (clickedSlot > 1 && clickedSlot < 22 ? !this.moveItemStackTo(clickedStack, 22, 58, true) : (clickedSlot < 2 ? !this.moveItemStackTo(clickedStack, 22, 58, false) : (((MechanicalSieveBlockEntity)this.machine).getLogic().isValidInput(clickedStack) ? !this.moveItemStackTo(clickedStack, 0, 1, false) : (((MechanicalSieveBlockEntity)this.machine).getLogic().isValidMesh(clickedStack) ? !this.moveItemStackTo(clickedStack, 1, 2, false) : (clickedSlot < 49 ? !this.moveItemStackTo(clickedStack, 49, 58, false) : clickedSlot < 58 && !this.moveItemStackTo(clickedStack, 22, 49, false)))))) {
                return ItemStack.EMPTY;
            }
            if (clickedStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (clickedStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, clickedStack);
            this.broadcastChanges();
        }
        return stack;
    }
}

