/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.event;

import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.client.CompostColors;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.item.PorcelainBucket;
import thedarkcolour.exdeorum.item.WateringCanItem;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.network.NetworkHandler;
import thedarkcolour.exdeorum.network.VisualUpdateTracker;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.tag.EBiomeTags;
import thedarkcolour.exdeorum.voidworld.VoidChunkGenerator;

public final class EventHandler {
    public static void register(IEventBus modBus) {
        IEventBus fmlBus = NeoForge.EVENT_BUS;
        fmlBus.addListener(EventHandler::onPlayerLogin);
        fmlBus.addListener(EventHandler::addReloadListeners);
        fmlBus.addListener(EventHandler::createSpawnTree);
        modBus.addListener(EventHandler::interModEnqueue);
        modBus.addListener(EventHandler::onCommonSetup);
        modBus.addListener(EventHandler::registerPayloadHandler);
        fmlBus.addListener(EventHandler::serverShutdown);
        fmlBus.addListener(EventHandler::serverTick);
        modBus.addListener(EventHandler::registerCapabilities);
        if (ExDeorum.DEBUG) {
            fmlBus.addListener(EventHandler::handleDebugCommands);
        }
    }

    private static void serverShutdown(ServerStoppingEvent event) {
        RecipeUtil.unload();
    }

    private static void handleDebugCommands(ClientChatEvent event) {
        if (event.getMessage().equals(".compost_colors")) {
            event.setCanceled(true);
            CompostColors.debugCompute();
            CompostColors.export("minecraft");
            CompostColors.loadColors();
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)("Reloaded " + CompostColors.COLORS.size() + " compost colors!")), false);
            }
        } else if (event.getMessage().equals(".breakpoint")) {
            event.setCanceled(true);
        }
    }

    private static void createSpawnTree(LevelEvent.CreateSpawnPosition event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).getChunkSource().getGenerator() instanceof VoidChunkGenerator) {
            Holder.Reference value;
            XoroshiroRandomSource rand = new XoroshiroRandomSource(level.getSeed());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(rand.nextIntBetweenInclusive(-200, 200), 64, rand.nextIntBetweenInclusive(-200, 200));
            level.setBlock((BlockPos)pos, Blocks.DIRT.defaultBlockState(), 2);
            pos.move(0, 1, 0);
            Registry configuredFeatureRegistry = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
            ResourceKey defaultTreeFeature = TreeFeatures.OAK_BEES_005;
            ResourceLocation defaultTreeFeatureLoc = ResourceLocation.tryParse((String)((String)EConfig.SERVER.defaultSpawnTreeFeature.get()));
            DeferredHolder<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> holder = configuredFeatureRegistry.getHolder(defaultTreeFeature).orElse(null);
            if (defaultTreeFeatureLoc != null && (value = (Holder.Reference)configuredFeatureRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)defaultTreeFeatureLoc)).orElse(null)) != null) {
                holder = value;
            }
            if (((Boolean)EConfig.SERVER.useBiomeAppropriateTree.get()).booleanValue()) {
                Holder biome = level.getBiome((BlockPos)pos);
                for (Map.Entry<TagKey<Biome>, DeferredHolder<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>>> entry : EBiomeTags.TREE_TAGS.entrySet()) {
                    DeferredHolder<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> optional;
                    if (!biome.is(entry.getKey()) || !(optional = entry.getValue()).isBound()) continue;
                    holder = optional;
                    break;
                }
            }
            if (holder == null || !((ConfiguredFeature)holder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), (RandomSource)rand, (BlockPos)pos)) {
                ExDeorum.LOGGER.error("Failed to generate spawn tree :(");
            } else {
                ExDeorum.LOGGER.debug("Generated spawn tree at {}", (Object)pos);
            }
            event.setCanceled(true);
            event.getSettings().setSpawn(level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)pos), 90.0f);
            ((GameRules.IntegerValue)level.getGameRules().getRule(GameRules.RULE_SPAWN_RADIUS)).set(0, level.getServer());
        }
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        CompostColors.loadColors();
        event.enqueueWork(() -> {
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)EFluids.WITCH_WATER_TYPE.get(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : ((Boolean)EConfig.SERVER.witchWaterNetherrackGenerator.get() != false ? Blocks.NETHERRACK.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState())));
            BlockState[] dirtVariants = new BlockState[]{Blocks.DIRT.defaultBlockState(), Blocks.PODZOL.defaultBlockState(), Blocks.COARSE_DIRT.defaultBlockState()};
            RandomSource rng = RandomSource.create();
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)EFluids.WITCH_WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, pos, relative, state) -> level.getFluidState(relative).getFluidType() == NeoForgeMod.WATER_TYPE.value() && (Boolean)EConfig.SERVER.witchWaterDirtGenerator.get() != false, fluidState -> (BlockState)Util.getRandom((Object[])dirtVariants, (RandomSource)rng)));
            BarrelMaterial.loadTransparentBlocks();
        });
    }

    private static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        NetworkHandler.register(event.registrar("exdeorum"));
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ChunkGenerator generator = player2.serverLevel().getChunkSource().getGenerator();
            if (generator instanceof VoidChunkGenerator || generator.getClass().getName().toLowerCase(Locale.ROOT).contains("skyblock")) {
                NetworkHandler.sendVoidWorld(player2);
                AdvancementHolder advancement = player2.server.getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"exdeorum", (String)"core/root"));
                if (advancement != null) {
                    if (!player2.getAdvancements().getOrStartProgress(advancement).isDone()) {
                        player2.getAdvancements().award(advancement, "in_void_world");
                        if (((Boolean)EConfig.SERVER.startingTorch.get()).booleanValue()) {
                            player2.getInventory().add(new ItemStack((ItemLike)Items.TORCH));
                        }
                        if (((Boolean)EConfig.SERVER.startingWateringCan.get()).booleanValue()) {
                            player2.getInventory().add(WateringCanItem.getFull(EItems.WOODEN_WATERING_CAN));
                        }
                    }
                } else {
                    ExDeorum.LOGGER.error("Unable to grant player the Void World advancement. Ex Deorum advancements will not show");
                }
            }
        } else if (Minecraft.getInstance().getConnection() != null) {
            RecipeUtil.reload(Minecraft.getInstance().getConnection().getRecipeManager());
        }
    }

    private static void interModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            // empty if block
        }
        if (ModList.get().isLoaded("inventorysorter")) {
            InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", ItemHelper.Slot.class::getName);
        }
    }

    private static void addReloadListeners(AddReloadListenerEvent event) {
        RecipeManager recipes = event.getServerResources().getRecipeManager();
        event.addListener((prepBarrier, resourceManager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> prepBarrier.wait((Object)Unit.INSTANCE).thenRunAsync(() -> RecipeUtil.reload(recipes), gameExecutor));
    }

    private static void serverTick(ServerTickEvent.Post event) {
        VisualUpdateTracker.syncVisualUpdates(event.getServer());
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EBlockEntities.BARREL.get(), (barrel, direction) -> barrel.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)EBlockEntities.BARREL.get(), (barrel, direction) -> barrel.getTank());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), (sieve, direction) -> sieve.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), (sieve, direction) -> sieve.getEnergyStorage());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get(), (hammer, direction) -> hammer.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get(), (hammer, direction) -> hammer.getEnergyStorage());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EBlockEntities.LAVA_CRUCIBLE.get(), (hammer, direction) -> hammer.getItem());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)EBlockEntities.LAVA_CRUCIBLE.get(), (hammer, direction) -> hammer.getTank());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EBlockEntities.WATER_CRUCIBLE.get(), (hammer, direction) -> hammer.getItem());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)EBlockEntities.WATER_CRUCIBLE.get(), (hammer, direction) -> hammer.getTank());
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new PorcelainBucket.ItemHandler((ItemStack)stack), new ItemLike[]{EItems.PORCELAIN_BUCKET, EItems.PORCELAIN_WATER_BUCKET, EItems.PORCELAIN_LAVA_BUCKET, EItems.PORCELAIN_MILK_BUCKET, EItems.PORCELAIN_WITCH_WATER_BUCKET});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new WateringCanItem.FluidHandler((ItemStack)stack), new ItemLike[]{EItems.WOODEN_WATERING_CAN, EItems.STONE_WATERING_CAN, EItems.IRON_WATERING_CAN, EItems.GOLDEN_WATERING_CAN, EItems.DIAMOND_WATERING_CAN, EItems.NETHERITE_WATERING_CAN});
    }
}

