/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredItem;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.data.recipe.Recipes;
import thedarkcolour.exdeorum.recipe.sieve.CompressedSieveRecipe;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.tag.EItemTags;
import thedarkcolour.modkit.data.MKRecipeProvider;

class SieveRecipes {
    private static final Ingredient DIRT = MKRecipeProvider.ingredient((ItemLike)Items.DIRT);
    private static final Ingredient GRAVEL = MKRecipeProvider.ingredient((ItemLike)Items.GRAVEL);
    private static final Ingredient SAND = MKRecipeProvider.ingredient((ItemLike)Items.SAND);
    private static final Ingredient DUST = MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.DUST.get()));
    private static final Ingredient RED_SAND = MKRecipeProvider.ingredient((ItemLike)Items.RED_SAND);
    private static final Ingredient CRUSHED_DEEPSLATE = MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.CRUSHED_DEEPSLATE.get()));
    private static final Ingredient CRUSHED_BLACKSTONE = MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.CRUSHED_BLACKSTONE.get()));
    private static final Ingredient CRUSHED_NETHERRACK = MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.CRUSHED_NETHERRACK.get()));
    private static final Ingredient SOUL_SAND = MKRecipeProvider.ingredient((ItemLike)Items.SOUL_SAND);
    private static final Ingredient CRUSHED_END_STONE = MKRecipeProvider.ingredient(EItems.CRUSHED_END_STONE);
    private static final Ingredient MOSS_BLOCK = MKRecipeProvider.ingredient((ItemLike)Items.MOSS_BLOCK);
    private static final Map<Ingredient, Ingredient> COMPRESSED_VARIANTS = ImmutableMap.builder().put((Object)DIRT, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_DIRT.getTag())).put((Object)GRAVEL, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_GRAVEL.getTag())).put((Object)SAND, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_SAND.getTag())).put((Object)DUST, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_DUST.getTag())).put((Object)RED_SAND, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_RED_SAND.getTag())).put((Object)CRUSHED_DEEPSLATE, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_CRUSHED_DEEPSLATE.getTag())).put((Object)CRUSHED_BLACKSTONE, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_CRUSHED_BLACKSTONE.getTag())).put((Object)CRUSHED_NETHERRACK, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_CRUSHED_NETHERRACK.getTag())).put((Object)SOUL_SAND, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_SOUL_SAND.getTag())).put((Object)CRUSHED_END_STONE, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_CRUSHED_END_STONE.getTag())).put((Object)MOSS_BLOCK, (Object)MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_MOSS_BLOCK.getTag())).build();

    SieveRecipes() {
    }

    static void sieveRecipes(RecipeOutput writer) {
        List<DeferredItem<Item>> allMeshes = List.of(EItems.STRING_MESH, EItems.FLINT_MESH, EItems.IRON_MESH, EItems.GOLDEN_MESH, EItems.DIAMOND_MESH, EItems.NETHERITE_MESH);
        SieveRecipes.forMesh(writer, DIRT, EItems.STRING_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)7, (float)0.6f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.25f));
            drops.add(Items.WHEAT_SEEDS, (NumberProvider)SieveRecipes.chance(0.125f));
            drops.add(Items.MELON_SEEDS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.PUMPKIN_SEEDS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.BEETROOT_SEEDS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.SUGAR_CANE, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.POISONOUS_POTATO, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.04f));
        });
        SieveRecipes.forMesh(writer, DIRT, EItems.FLINT_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)7, (float)0.6f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.3f));
            drops.add((Item)EItems.ANDESITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)7, (float)0.4f));
            drops.add((Item)EItems.GRANITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)7, (float)0.4f));
            drops.add((Item)EItems.DIORITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)7, (float)0.4f));
            drops.add(Items.WHEAT_SEEDS, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.MELON_SEEDS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.PUMPKIN_SEEDS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.SUGAR_CANE, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.POISONOUS_POTATO, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.PINK_PETALS, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.SWEET_BERRIES, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.addConditional((ItemLike)ModCompatData.SOURCEBERRY.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.modInstalled("ars_nouveau"));
        });
        SieveRecipes.forMesh(writer, DIRT, EItems.IRON_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)8, (float)0.65f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.45f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.3f));
            drops.add(Items.WHEAT_SEEDS, (NumberProvider)SieveRecipes.chance(0.175f));
            drops.add(Items.MELON_SEEDS, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.PUMPKIN_SEEDS, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.175f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.SUGAR_CANE, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, DIRT, EItems.GOLDEN_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)8, (float)0.7f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.55f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.WHEAT_SEEDS, (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.MELON_SEEDS, (NumberProvider)SieveRecipes.chance(0.165f));
            drops.add(Items.PUMPKIN_SEEDS, (NumberProvider)SieveRecipes.chance(0.165f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.175f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.175f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.25f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.GOLDEN_CARROT, (NumberProvider)SieveRecipes.chance(0.02f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.05f));
        });
        SieveRecipes.forMesh(writer, DIRT, EItems.DIAMOND_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)8, (float)0.7f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.6f));
            drops.add(Items.FLINT, (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.3f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.25f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.25f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, DIRT, EItems.NETHERITE_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.4f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.65f));
            drops.add(Items.FLINT, (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.4f));
            drops.add(Items.POTATO, (NumberProvider)SieveRecipes.chance(0.3f));
            drops.add(Items.CARROT, (NumberProvider)SieveRecipes.chance(0.3f));
            drops.add((Item)EItems.GRASS_SEEDS.get(), (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add((Item)EItems.MYCELIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.GOLDEN_CARROT, (NumberProvider)SieveRecipes.chance(0.01f));
            drops.add(Items.GOLDEN_APPLE, (NumberProvider)SieveRecipes.chance(0.0025f));
            drops.add(Items.BAMBOO, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.STRING_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.02f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.01f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.01f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.035f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.FLINT_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.ANDESITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add((Item)EItems.GRANITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add((Item)EItems.DIORITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add(Items.POINTED_DRIPSTONE, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.25f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.125f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.015f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.015f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.055f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.055f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.0325f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.IRON_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.55f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.055f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.045f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.045f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.GOLDEN_MESH, drops -> {
            drops.add((Item)EItems.STONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.55f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.02f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.DIAMOND_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.6f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.105f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, GRAVEL, EItems.NETHERITE_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)6, (float)0.625f));
            drops.add(Items.COAL, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.17f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.01f));
            drops.addConditional((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_ALUMINUM));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.ZINC_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_ZINC));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.055f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.STRING_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.KELP, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.SEA_PICKLE, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.005f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.FLINT_MESH, drops -> {
            drops.add(Items.FLINT, (NumberProvider)BinomialDistributionGenerator.binomial((int)2, (float)0.2f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.16f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.16f));
            drops.add((Item)EItems.RANDOM_POTTERY_SHERD.get(), (NumberProvider)SieveRecipes.chance(0.04f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.005f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.IRON_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.23f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.18f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.18f));
            drops.add(Items.KELP, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.SEA_PICKLE, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.PRISMARINE_SHARD, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.PRISMARINE_CRYSTALS, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.0125f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.GOLDEN_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.18f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.28f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.16f));
            drops.add(Items.KELP, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.SEA_PICKLE, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.PRISMARINE_SHARD, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.PRISMARINE_CRYSTALS, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add((Item)EItems.RANDOM_ARMOR_TRIM.get(), (NumberProvider)SieveRecipes.chance(0.02f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.015f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.DIAMOND_MESH, drops -> {
            drops.add(Items.FLINT, (NumberProvider)SieveRecipes.chance(0.23f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.22f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.22f));
            drops.add(Items.PRISMARINE_SHARD, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.PRISMARINE_CRYSTALS, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.02f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, SAND, EItems.NETHERITE_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.FLINT, (NumberProvider)BinomialDistributionGenerator.binomial((int)2, (float)0.23f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.23f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.23f));
            drops.add(Items.KELP, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.SEA_PICKLE, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.PRISMARINE_SHARD, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.PRISMARINE_CRYSTALS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.095f), Recipes.modInstalled("ae2"));
            drops.addConditional((ItemLike)ModCompatData.CHARGED_CERTUS_QUARTZ_CRYSTAL.get(), (NumberProvider)SieveRecipes.chance(0.035f), Recipes.modInstalled("ae2"));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.STRING_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.03f));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.FLINT_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.04f));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.IRON_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.GOLDEN_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.19f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.11f));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.DIAMOND_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.DEAD_BUSH, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.08f));
        });
        SieveRecipes.forMesh(writer, RED_SAND, EItems.NETHERITE_MESH, drops -> {
            drops.add(Items.CACTUS, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.17f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.1f));
        });
        SieveRecipes.forMesh(writer, DUST, EItems.STRING_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, DUST, EItems.FLINT_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, DUST, EItems.IRON_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, DUST, EItems.GOLDEN_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)2, (float)0.18f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.02f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, DUST, EItems.DIAMOND_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, DUST, EItems.NETHERITE_MESH, drops -> {
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.BONE_MEAL, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.REDSTONE, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.IRON_NUGGET, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.addConditional((ItemLike)ModCompatData.GRAINS_OF_INFINITY.get(), (NumberProvider)SieveRecipes.chance(0.135f), Recipes.ENDERIO);
            drops.addConditional((ItemLike)ModCompatData.SKY_STONE_DUST.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.AE2);
            drops.addConditional((ItemLike)ModCompatData.CERTUS_QUARTZ_DUST.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.AE2);
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.STRING_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.03f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.045f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.FLINT_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.TUFF_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add((Item)EItems.CALCITE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.IRON_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.6f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.06f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.GOLDEN_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.65f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.1f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.DIAMOND_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.65f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.18f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.13f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.075f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.095f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.08f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_DEEPSLATE, EItems.NETHERITE_MESH, drops -> {
            drops.add((Item)EItems.DEEPSLATE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.7f));
            drops.add((Item)EItems.COPPER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.IRON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.2f));
            drops.add((Item)EItems.GOLD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.AMETHYST_SHARD, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.DIAMOND, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.LAPIS_LAZULI, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.EMERALD, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.addConditional((ItemLike)EItems.SILVER_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_SILVER));
            drops.addConditional((ItemLike)EItems.LEAD_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_LEAD));
            drops.addConditional((ItemLike)EItems.OSMIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.14f), Recipes.tagNotEmpty(EItemTags.ORES_OSMIUM));
            drops.addConditional((ItemLike)EItems.NICKEL_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.15f), Recipes.tagNotEmpty(EItemTags.ORES_NICKEL));
            drops.addConditional((ItemLike)EItems.TIN_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.16f), Recipes.tagNotEmpty(EItemTags.ORES_TIN));
            drops.addConditional((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_IRIDIUM));
            drops.addConditional((ItemLike)EItems.PLATINUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_PLATINUM));
            drops.addConditional((ItemLike)EItems.URANIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.12f), Recipes.tagNotEmpty(EItemTags.ORES_URANIUM));
            drops.addConditional((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.14f), Recipes.tagNotEmpty(EItemTags.ORES_MAGNESIUM));
            drops.addConditional((ItemLike)EItems.THORIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_THORIUM));
            drops.addConditional((ItemLike)EItems.BORON_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_BORON));
            drops.addConditional((ItemLike)EItems.LITHIUM_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.085f), Recipes.tagNotEmpty(EItemTags.ORES_LITHIUM));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.STRING_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.6f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.5f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.02f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.2f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.BLACK_DYE, (NumberProvider)SieveRecipes.chance(0.07f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.FLINT_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.65f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.55f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.225f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.BLACK_DYE, (NumberProvider)SieveRecipes.chance(0.08f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.IRON_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.65f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.55f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.25f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.BLACK_DYE, (NumberProvider)SieveRecipes.chance(0.08f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.GOLDEN_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.7f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)8, (float)0.325f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.BLACK_DYE, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.DIAMOND_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.7f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.275f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.11f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_BLACKSTONE, EItems.NETHERITE_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.75f));
            drops.add(Items.ANCIENT_DEBRIS, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.325f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.11f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.STRING_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.4f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.3f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add((Item)EItems.WARPED_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.05f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.04f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.FLINT_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.5f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.4f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add((Item)EItems.WARPED_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.05f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.IRON_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.6f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.45f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add((Item)EItems.WARPED_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.065f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.GOLDEN_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.6f));
            drops.add((Item)EItems.BASALT_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.45f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add((Item)EItems.WARPED_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.RAW_GOLD, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.07f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.DIAMOND_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)4, (float)0.6f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.09f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, CRUSHED_NETHERRACK, EItems.NETHERITE_MESH, drops -> {
            drops.add((Item)EItems.BLACKSTONE_PEBBLE.get(), (NumberProvider)BinomialDistributionGenerator.binomial((int)5, (float)0.65f));
            drops.add(Items.BLAZE_POWDER, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.MAGMA_CREAM, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.addConditional((ItemLike)EItems.COBALT_ORE_CHUNK.get(), (NumberProvider)SieveRecipes.chance(0.11f), Recipes.tagNotEmpty(EItemTags.ORES_COBALT));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.STRING_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.BONE, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.06f));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.FLINT_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.BONE, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add((Item)EItems.WARPED_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), (NumberProvider)SieveRecipes.chance(0.03f));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.IRON_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.BONE, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.05f));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.GOLDEN_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.17f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.BONE, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.GOLD_NUGGET, (NumberProvider)SieveRecipes.chance(0.15f));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.DIAMOND_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.19f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.1f));
        });
        SieveRecipes.forMesh(writer, SOUL_SAND, EItems.NETHERITE_MESH, drops -> {
            drops.add(Items.QUARTZ, (NumberProvider)SieveRecipes.chance(0.21f));
            drops.add(Items.GUNPOWDER, (NumberProvider)SieveRecipes.chance(0.14f));
            drops.add(Items.GHAST_TEAR, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.GLOWSTONE_DUST, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.NETHER_WART, (NumberProvider)SieveRecipes.chance(0.12f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.STRING_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.02f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.FLINT_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.08f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.11f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.03f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.IRON_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.13f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.07f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.04f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.GOLDEN_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.12f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.06f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.07f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.DIAMOND_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.15f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.09f));
        });
        SieveRecipes.forMesh(writer, CRUSHED_END_STONE, EItems.NETHERITE_MESH, drops -> {
            drops.add(Items.ENDER_PEARL, (NumberProvider)SieveRecipes.chance(0.17f));
            drops.add(Items.CHORUS_FRUIT, (NumberProvider)SieveRecipes.chance(0.1f));
            drops.add(Items.CHORUS_FLOWER, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.ENDER_EYE, (NumberProvider)SieveRecipes.chance(0.09f));
            drops.add(Items.ECHO_SHARD, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.SCULK_SHRIEKER, (NumberProvider)SieveRecipes.chance(0.01f));
        });
        int i = 0;
        while (i < allMeshes.size()) {
            DeferredItem<Item> mesh = allMeshes.get(i);
            int j = i++;
            SieveRecipes.forMesh(writer, MOSS_BLOCK, mesh, drops -> {
                drops.add(Items.OAK_SAPLING, (NumberProvider)SieveRecipes.chance(0.13f));
                drops.add(Items.SPRUCE_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.BIRCH_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.ACACIA_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.DARK_OAK_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.JUNGLE_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.CHERRY_SAPLING, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.MANGROVE_PROPAGULE, (NumberProvider)SieveRecipes.chance(0.11f));
                drops.add(Items.AZALEA, (NumberProvider)SieveRecipes.chance(0.08f + (float)j * 0.01f));
                drops.add(Items.GLOW_BERRIES, (NumberProvider)SieveRecipes.chance(0.04f + (float)j * 0.075f));
                drops.add(Items.SMALL_DRIPLEAF, (NumberProvider)SieveRecipes.chance(0.07f + (float)j * 0.025f));
                drops.add(Items.BIG_DRIPLEAF, (NumberProvider)SieveRecipes.chance(0.05f + (float)j * 0.02f));
                drops.add(Items.SPORE_BLOSSOM, (NumberProvider)SieveRecipes.chance(0.03f + (float)j * 0.015f));
                ICondition bop = Recipes.modInstalled("biomesoplenty");
                drops.addConditional((ItemLike)ModCompatData.ORIGIN_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.FLOWERING_OAK_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.SNOWBLOSSOM_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.RAINBOW_BIRCH_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.YELLOW_AUTUMN_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.ORANGE_AUTUMN_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.MAPLE_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.FIR_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.REDWOOD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.MAHOGANY_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.JACARANDA_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.PALM_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.WILLOW_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.DEAD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.MAGIC_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.UMBRAN_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                drops.addConditional((ItemLike)ModCompatData.HELLBARK_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.04f), bop);
                ICondition ars = Recipes.modInstalled("ars_nouveau");
                drops.addConditional((ItemLike)ModCompatData.BLUE_ARCHWOOD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.005f), ars);
                drops.addConditional((ItemLike)ModCompatData.RED_ARCHWOOD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.005f), ars);
                drops.addConditional((ItemLike)ModCompatData.PURPLE_ARCHWOOD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.005f), ars);
                drops.addConditional((ItemLike)ModCompatData.GREEN_ARCHWOOD_SAPLING.get(), (NumberProvider)SieveRecipes.chance(0.005f), ars);
                drops.addConditional((ItemLike)ModCompatData.SOURCEBERRY.get(), (NumberProvider)SieveRecipes.chance(0.01f), ars);
            });
        }
        SieveRecipes.forMesh(writer, MOSS_BLOCK, EItems.FLINT_MESH, drops -> {
            drops.add(Items.SWEET_BERRIES, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.FLOWERING_AZALEA, (NumberProvider)SieveRecipes.chance(0.03f));
            drops.add(Items.GLOW_LICHEN, (NumberProvider)SieveRecipes.chance(0.04f));
            drops.add(Items.LILY_PAD, (NumberProvider)SieveRecipes.chance(0.04f));
        });
    }

    private static BinomialDistributionGenerator chance(float p) {
        return BinomialDistributionGenerator.binomial((int)1, (float)p);
    }

    private static void forMesh(RecipeOutput output, Ingredient block, DeferredItem<? extends Item> mesh, Consumer<MeshDrops> addDrops) {
        String folder = mesh.getId().getPath().replace("_mesh", "/");
        String basePath = MKRecipeProvider.path((ItemLike)block.getItems()[0].getItem()) + "/" + folder;
        addDrops.accept(new MeshDrops(output, "sieve/" + basePath, "compressed_sieve/" + basePath, block, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)mesh.get()})));
    }

    private record MeshDrops(RecipeOutput output, String basePath, String baseCompressedPath, Ingredient block, Ingredient mesh) {
        private void add(Item result, NumberProvider resultAmount) {
            this.output.accept(Recipes.modLoc(this.basePath + MKRecipeProvider.path((ItemLike)result)), (Recipe)new SieveRecipe(this.block, new ItemStack((ItemLike)result), resultAmount, this.mesh, false), null);
            if (COMPRESSED_VARIANTS.containsKey(this.block)) {
                ResourceLocation compressedLoc = Recipes.modLoc(this.baseCompressedPath + MKRecipeProvider.path((ItemLike)result));
                NumberProvider multiplied = Recipes.compressedMultiplier(resultAmount);
                this.output.accept(compressedLoc, (Recipe)new CompressedSieveRecipe(COMPRESSED_VARIANTS.get(this.block), new ItemStack((ItemLike)result), multiplied, this.mesh, false), null);
            }
        }

        private void addConditional(ItemLike result, NumberProvider resultAmount, ICondition condition) {
            ResourceLocation path = Recipes.modLoc(this.basePath + MKRecipeProvider.path((ItemLike)result));
            this.output.accept(path, (Recipe)new SieveRecipe(this.block, new ItemStack(result), resultAmount, this.mesh, false), null, new ICondition[]{condition});
            if (COMPRESSED_VARIANTS.containsKey(this.block)) {
                ResourceLocation compressedLoc = Recipes.modLoc(this.baseCompressedPath + MKRecipeProvider.path((ItemLike)result));
                NumberProvider multiplied = Recipes.compressedMultiplier(resultAmount);
                this.output.accept(compressedLoc, (Recipe)new CompressedSieveRecipe(COMPRESSED_VARIANTS.get(this.block), new ItemStack(result), multiplied, this.mesh, false), null, new ICondition[]{condition});
            }
        }
    }
}

