/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;

class ClientJeiUtil {
    ClientJeiUtil() {
    }

    static <T> void checkTypedIngredient(IIngredientManager manager, IIngredientType<T> ingredientType, @Nullable T uncheckedIngredient, Consumer<ITypedIngredient<T>> action) {
        FluidStack fluidStack;
        ItemStack stack;
        if (uncheckedIngredient instanceof ItemStack && !(stack = (ItemStack)uncheckedIngredient).isEmpty() || uncheckedIngredient instanceof FluidStack && !(fluidStack = (FluidStack)uncheckedIngredient).isEmpty()) {
            manager.createTypedIngredient(ingredientType, uncheckedIngredient).ifPresent(action);
        }
    }

    static <T> void showRecipes(IFocusFactory focusFactory, ITypedIngredient<T> ingredient) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IRecipesGui) {
            IRecipesGui recipesGui = (IRecipesGui)screen;
            recipesGui.show(focusFactory.createFocus(RecipeIngredientRole.OUTPUT, ingredient));
        }
    }

    static <T> void showUsages(IFocusFactory focusFactory, ITypedIngredient<T> ingredient) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IRecipesGui) {
            IRecipesGui recipesGui = (IRecipesGui)screen;
            recipesGui.show(List.of(focusFactory.createFocus(RecipeIngredientRole.INPUT, ingredient), focusFactory.createFocus(RecipeIngredientRole.CATALYST, ingredient)));
        }
    }

    static enum AsteriskItemRenderer implements IIngredientRenderer<ItemStack>
    {
        INSTANCE;


        public void render(GuiGraphics graphics, @Nullable ItemStack ingredient) {
            if (ingredient != null) {
                RenderSystem.enableDepthTest();
                ClientXeiUtil.renderItemWithAsterisk(graphics, ingredient);
                RenderSystem.disableDepthTest();
            }
        }

        public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            return ingredient.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player, tooltipFlag);
        }
    }
}

