/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.ter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.client.RenderFace;
import thedarkcolour.exdeorum.client.RenderUtil;

public class SieveRenderer<T extends EBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Map<Item, TextureAtlasSprite> MESH_TEXTURES = new HashMap<Item, TextureAtlasSprite>();
    private final float meshHeight;
    private final float contentsMinY;
    private final float contentsMaxY;

    public SieveRenderer(float meshHeight, float contentsMaxY) {
        this.meshHeight = meshHeight;
        this.contentsMinY = meshHeight * 16.0f + 1.0f;
        this.contentsMaxY = contentsMaxY;
    }

    public void render(T sieve, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        ItemStack mesh;
        Item item;
        SieveLogic logic = ((SieveLogic.Owner)sieve).getLogic();
        ItemStack contents = logic.getContents();
        if (!contents.isEmpty() && (item = contents.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            float percentage = logic.getProgress();
            RenderFace face = RenderUtil.getTopFace(block);
            if (this.shouldContentsRender3d(sieve)) {
                face.renderCuboid(buffers, stack, this.contentsMinY / 16.0f, Mth.lerp((float)percentage, (float)this.contentsMaxY, (float)this.contentsMinY) / 16.0f, 255, 255, 255, light, 1.0f);
            } else {
                face.renderFlatSpriteLerp(buffers, stack, percentage, 255, 255, 255, light, 1.0f, this.contentsMaxY, this.contentsMinY);
            }
        }
        if (!(mesh = logic.getMesh()).isEmpty()) {
            TextureAtlasSprite meshSprite;
            VertexConsumer builder = buffers.getBuffer(RenderType.cutoutMipped());
            Item meshItem = mesh.getItem();
            if (MESH_TEXTURES.containsKey(meshItem)) {
                meshSprite = MESH_TEXTURES.get(meshItem);
            } else {
                ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)meshItem);
                ResourceLocation textureLoc = registryName.withPrefix("item/mesh/");
                meshSprite = RenderUtil.blockAtlas.getSprite(textureLoc);
                MESH_TEXTURES.put(meshItem, meshSprite);
            }
            RenderUtil.renderFlatSprite(builder, stack, this.meshHeight, 255, 255, 255, meshSprite, light, 1.0f);
            if (mesh.hasFoil()) {
                RenderUtil.renderFlatSprite(buffers.getBuffer(RenderType.glint()), stack, this.meshHeight, 255, 255, 255, meshSprite, light, 1.0f);
            }
        }
    }

    protected boolean shouldContentsRender3d(T sieve) {
        return false;
    }
}

