/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.ter;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import thedarkcolour.exdeorum.blockentity.AbstractCrucibleBlockEntity;
import thedarkcolour.exdeorum.client.RenderFace;
import thedarkcolour.exdeorum.client.RenderUtil;

public class CrucibleRenderer
implements BlockEntityRenderer<AbstractCrucibleBlockEntity> {
    public void render(AbstractCrucibleBlockEntity crucible, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        FluidTank tank = crucible.getTank();
        Level level = crucible.getLevel();
        if (level == null) {
            return;
        }
        FluidStack fluidStack = tank.getFluidInTank(0);
        float solids = (float)crucible.getSolids() / 1000.0f;
        float liquid = (float)fluidStack.getAmount() / (float)tank.getTankCapacity(0);
        if (solids != 0.0f || liquid != 0.0f) {
            BlockPos pos = crucible.getBlockPos();
            if (liquid != 0.0f) {
                Fluid fluid = fluidStack.getFluid();
                int color = RenderUtil.getFluidColor(fluid, level, pos);
                float y = Mth.lerp((float)liquid, (float)0.25f, (float)0.875f);
                RenderUtil.renderFlatFluidSprite(buffers, stack, level, pos, y, 2.0f, light, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, fluid);
            }
            if (solids != 0.0f) {
                Block lastMelted = crucible.getLastMelted();
                if (lastMelted == null) {
                    lastMelted = crucible.getDefaultMeltBlock();
                }
                RenderFace face = RenderUtil.getTopFaceOrDefault(lastMelted, crucible.getDefaultMeltBlock());
                int color = Minecraft.getInstance().getBlockColors().getColor(lastMelted.defaultBlockState(), (BlockAndTintGetter)level, pos, 0);
                if (color == -1) {
                    color = 0xFFFFFF;
                }
                face.renderFlatSpriteLerp(buffers, stack, solids, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, light, 2.0f, 4.0f, 14.0f);
            }
        }
    }
}

