/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.MechanicalSieveBlockEntity;
import thedarkcolour.exdeorum.client.screen.RedstoneControlWidget;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;
import thedarkcolour.exdeorum.menu.MechanicalSieveMenu;

public class MechanicalSieveScreen
extends AbstractContainerScreen<MechanicalSieveMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ExDeorum.loc("textures/gui/container/mechanical_sieve.png");
    public static final int RECIPE_CLICK_AREA_POS_X = 51;
    public static final int RECIPE_CLICK_AREA_POS_Y = 42;
    public static final int RECIPE_CLICK_AREA_WIDTH = 21;
    public static final int RECIPE_CLICK_AREA_HEIGHT = 14;
    @Nullable
    private RedstoneControlWidget redstoneControlWidget;

    public MechanicalSieveScreen(MechanicalSieveMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 173;
        this.inventoryLabelY += 7;
    }

    protected void init() {
        super.init();
        this.redstoneControlWidget = new RedstoneControlWidget((AbstractMachineMenu)this.menu, BACKGROUND_TEXTURE, this.leftPos + this.imageWidth, this.topPos + 3);
        this.addRenderableWidget(this.redstoneControlWidget);
    }

    @Nullable
    public RedstoneControlWidget getRedstoneControlWidget() {
        return this.redstoneControlWidget;
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mX, int mY) {
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(BACKGROUND_TEXTURE, left, top, 0, 0, this.imageWidth, this.imageHeight);
        int energy = Mth.floor((float)(54.0f * ((float)((MechanicalSieveMenu)this.menu).prevEnergy / (float)((Integer)EConfig.SERVER.mechanicalSieveEnergyStorage.get()).intValue())));
        graphics.blit(BACKGROUND_TEXTURE, left + 10, top + 22 + 54 - energy, this.imageWidth, 68 - energy, 12, energy);
        int progress = Math.min(21, (int)(((MechanicalSieveBlockEntity)((MechanicalSieveMenu)this.menu).machine).getLogic().getProgress() * 22.0f));
        graphics.blit(BACKGROUND_TEXTURE, left + 51, top + 42, this.imageWidth, 0, progress, 14);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        super.render(graphics, mx, my, partialTicks);
        this.renderTooltip(graphics, mx, my);
        int rx = mx - this.leftPos;
        int ry = my - this.topPos;
        if (9 <= rx && rx < 23 && 21 <= ry && ry < 77) {
            MutableComponent energyTooltip = Component.translatable((String)"gui.exdeorum.energy_label").append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{((MechanicalSieveMenu)this.menu).prevEnergy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).append(" FE");
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)energyTooltip, mx, my);
        }
    }
}

