/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity.helper;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHelper
extends FluidTank {
    public FluidHelper(int capacity) {
        super(capacity);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            int amount = Math.min(this.capacity, resource.getAmount());
            this.fluid = new FluidStack(resource.getFluid(), Math.min(this.capacity, amount));
            this.onContentsChanged();
            return amount;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    public FluidTank readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.readFromNBT(provider, nbt);
        if (!this.fluid.isEmpty()) {
            this.fluid.setAmount(Math.min(this.capacity, this.fluid.getAmount()));
        }
        return this;
    }
}

