/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.config.EConfig;

public class WitchWaterBlock
extends LiquidBlock {
    public WitchWaterBlock(Supplier<? extends FlowingFluid> pFluid, BlockBehaviour.Properties pProperties) {
        super(pFluid.get(), pProperties);
    }

    public void entityInside(BlockState pState, Level level, BlockPos pPos, Entity entity) {
        if (!level.isClientSide) {
            WitchWaterBlock.witchWaterEntityEffects(level, entity);
        }
    }

    public static void witchWaterEntityEffects(Level level, Entity entity) {
        if (entity.isAlive()) {
            EntityType entityType = entity.getType();
            if (((Boolean)EConfig.SERVER.allowWitchWaterEntityConversion.get()).booleanValue()) {
                if (entityType == EntityType.VILLAGER) {
                    Villager villager = (Villager)entity;
                    if (level.getDifficulty() != Difficulty.PEACEFUL) {
                        if (!villager.isBaby() && villager.getVillagerData().getProfession() == VillagerProfession.CLERIC) {
                            if (WitchWaterBlock.attemptToConvertEntity(level, (Entity)villager, EntityType.WITCH) != null) {
                                villager.releaseAllPois();
                            }
                        } else {
                            ZombieVillager zombieVillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false);
                            if (zombieVillager != null) {
                                EventHooks.finalizeMobSpawn((Mob)zombieVillager, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.getCurrentDifficultyAt(zombieVillager.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
                                zombieVillager.setVillagerData(villager.getVillagerData());
                                zombieVillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                                zombieVillager.setTradeOffers(villager.getOffers().copy());
                                zombieVillager.setVillagerXp(villager.getVillagerXp());
                                EventHooks.onLivingConvert((LivingEntity)villager, (LivingEntity)zombieVillager);
                                villager.discard();
                            }
                        }
                    }
                } else if (entityType == EntityType.SKELETON) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.WITHER_SKELETON);
                } else if (entityType == EntityType.CREEPER) {
                    entity.getEntityData().set(Creeper.DATA_IS_POWERED, (Object)true);
                } else if (entityType == EntityType.SPIDER) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.CAVE_SPIDER);
                } else if (entityType == EntityType.SQUID) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.GHAST);
                } else if (entityType == EntityType.PIG || entityType == EntityType.PIGLIN) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.ZOMBIFIED_PIGLIN);
                } else if (entityType == EntityType.HOGLIN) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.ZOGLIN);
                } else if (entityType == EntityType.MOOSHROOM) {
                    ((MushroomCow)entity).setVariant(MushroomCow.MushroomType.BROWN);
                } else if (entityType == EntityType.AXOLOTL) {
                    ((Axolotl)entity).setVariant(Axolotl.Variant.BLUE);
                } else if (entityType == EntityType.RABBIT) {
                    ((Rabbit)entity).setVariant(Rabbit.Variant.EVIL);
                } else if (entityType == EntityType.PUFFERFISH) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.GUARDIAN);
                } else if (entityType == EntityType.HORSE) {
                    if (level.random.nextBoolean()) {
                        WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.ZOMBIE_HORSE);
                    } else {
                        WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.SKELETON_HORSE);
                    }
                }
            }
            if (entityType == EntityType.PLAYER) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 210));
                living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 210, 2));
                living.addEffect(new MobEffectInstance(MobEffects.WITHER, 210));
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 210));
            }
        }
    }

    @Nullable
    private static <T extends Mob> T attemptToConvertEntity(Level level, Entity entity, EntityType<T> newType) {
        if (level.getDifficulty() != Difficulty.PEACEFUL && entity instanceof LivingEntity) {
            Mob newEntity = (Mob)newType.create(level);
            if (newEntity != null) {
                ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                newEntity.copyPosition(entity);
                EventHooks.finalizeMobSpawn((Mob)newEntity, (ServerLevelAccessor)serverLevel, (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, null);
                newEntity.setNoAi(newEntity.isNoAi());
                if (entity.hasCustomName()) {
                    newEntity.setCustomName(entity.getCustomName());
                    newEntity.setCustomNameVisible(entity.isCustomNameVisible());
                }
                newEntity.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)((LivingEntity)entity), (LivingEntity)newEntity);
                serverLevel.addFreshEntityWithPassengers((Entity)newEntity);
                entity.discard();
            }
            return (T)newEntity;
        }
        return null;
    }
}

