/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import thedarkcolour.exdeorum.block.MachineBlock;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class MechanicalHammerBlock
extends MachineBlock {
    public static final BooleanProperty RUNNING = BooleanProperty.create((String)"running");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public MechanicalHammerBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.MECHANICAL_HAMMER);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)RUNNING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RUNNING, FACING});
    }

    @Override
    protected int getHighlightItemSlot() {
        return 1;
    }

    @Override
    protected MutableComponent getHighlightItemLabel() {
        return Component.translatable((String)"item.exdeorum.mechanical_hammer.hammer_label");
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        CompoundTag nbt;
        BlockState state = this.defaultBlockState();
        CustomData customData = (CustomData)context.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && (nbt = customData.getUnsafe()).contains("progress") && nbt.getInt("progress") != -1) {
            state = (BlockState)state.setValue((Property)RUNNING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

