/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.InfestedLeavesBlockEntity;
import thedarkcolour.exdeorum.client.RenderUtil;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EBlocks;

public class InfestedLeavesBlock
extends LeavesBlock
implements EntityBlock {
    public static final BooleanProperty FULLY_INFESTED = BooleanProperty.create((String)"fully_infested");

    public InfestedLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FULLY_INFESTED, (Comparable)Boolean.valueOf(false)));
    }

    public static void setBlock(Level level, BlockPos pos, BlockState fromState) {
        level.setBlock(pos, (BlockState)((BlockState)((InfestedLeavesBlock)((Object)EBlocks.INFESTED_LEAVES.get())).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)(fromState.hasProperty((Property)LeavesBlock.DISTANCE) ? (Integer)fromState.getValue((Property)LeavesBlock.DISTANCE) : Integer.valueOf(0)))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)(fromState.hasProperty((Property)LeavesBlock.PERSISTENT) ? (Boolean)fromState.getValue((Property)LeavesBlock.PERSISTENT) : Boolean.valueOf(false))), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FULLY_INFESTED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (ctx.getPlayer() != null) {
            return (BlockState)this.defaultBlockState().setValue((Property)FULLY_INFESTED, (Comparable)Boolean.valueOf(true));
        }
        return super.getStateForPlacement(ctx);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState pState, @Nullable LivingEntity player, ItemStack pStack) {
        BlockEntity blockEntity;
        if (player != null && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof InfestedLeavesBlockEntity) {
            InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)blockEntity;
            leaves.setProgress((short)16000);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InfestedLeavesBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState state, BlockEntityType<T> type) {
        return type == EBlockEntities.INFESTED_LEAVES.get() ? new InfestedLeavesBlockEntity.Ticker() : null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InfestedLeavesBlockEntity) {
            InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)blockEntity;
            return leaves.getMimic().getCloneItemStack(target, level, pos, player);
        }
        return ItemStack.EMPTY;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.decaying(state)) {
            level.removeBlock(pos, false);
        }
    }

    public RenderShape getRenderShape(BlockState pState) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return RenderShape.MODEL;
        }
        return EConfig.CLIENT_SPEC.isLoaded() && (Boolean)EConfig.CLIENT.useFastInfestedLeaves.get() != false || RenderUtil.IRIS_ACCESS.areShadersEnabled() ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }
}

