/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.transfer;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.itemlists.CraftingHelper;
import appeng.integration.modules.itemlists.TransferHelper;
import appeng.menu.me.items.CraftingTermMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import tamaized.ae2jeiintegration.integration.modules.jei.transfer.AbstractTransferHandler;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, RecipeHolder<CraftingRecipe>> {
    private final Class<T> menuClass;
    private final MenuType<T> menuType;
    private final IRecipeTransferHandlerHelper helper;

    public UseCraftingRecipeTransfer(Class<T> menuClass, MenuType<T> menuType, IRecipeTransferHandlerHelper helper) {
        this.menuClass = menuClass;
        this.menuType = menuType;
        this.helper = helper;
    }

    public IRecipeTransferError transferRecipe(T menu, RecipeHolder<CraftingRecipe> recipeHolder, IRecipeSlotsView display, Player player, boolean maxTransfer, boolean doTransfer) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe.getType() != net.minecraft.world.item.crafting.RecipeType.CRAFTING) {
            return this.helper.createInternalError();
        }
        if (recipe.getIngredients().isEmpty()) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        if (!recipe.canCraftInDimensions(3, 3)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        boolean craftMissing = AbstractContainerScreen.hasControlDown();
        List inputSlots = display.getSlotViews(RecipeIngredientRole.INPUT);
        Map slotToIngredientMap = this.helper.getGuiSlotIndexToIngredientMap(recipeHolder);
        CraftingTermMenu.MissingIngredientSlots missingSlots = menu.findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new ErrorRenderer(missingSlots, craftMissing, color);
            }
        } else {
            CraftingHelper.performTransfer(menu, (ResourceLocation)recipeHolder.id(), (Recipe)recipe, (boolean)craftMissing);
        }
        return null;
    }

    public Class<T> getContainerClass() {
        return this.menuClass;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    private record ErrorRenderer(CraftingTermMenu.MissingIngredientSlots indices, boolean craftMissing, int color) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public int getButtonHighlightColor() {
            return this.color;
        }

        public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView slots, int recipeX, int recipeY) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)recipeX, (float)recipeY, 0.0f);
            List slotViews = slots.getSlotViews(RecipeIngredientRole.INPUT);
            for (int i = 0; i < slotViews.size(); ++i) {
                IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
                boolean missing = this.indices.missingSlots().contains(i);
                boolean craftable = this.indices.craftableSlots().contains(i);
                if (!missing && !craftable) continue;
                slotView.drawHighlight(guiGraphics, missing ? 0x66FF0000 : 0x400000FF);
            }
            poseStack.popPose();
        }

        public int getMissingCountHint() {
            return this.indices.missingSlots().size();
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            tooltip.addAll((Collection)TransferHelper.createCraftingTooltip((CraftingTermMenu.MissingIngredientSlots)this.indices, (boolean)this.craftMissing, (boolean)true));
        }
    }
}

