/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModStairBlock
extends StairBlock {
    public static final MapCodec<ModStairBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("base_block").forGetter(ModStairBlock::getBaseBlock), (App)ModStairBlock.propertiesCodec()).apply((Applicative)i, (b, s) -> new ModStairBlock(() -> b, (BlockBehaviour.Properties)s)));
    private static final Field FORGE_BLOCK_SUPPLIER = PlatHelper.findField(StairBlock.class, "stateSupplier");
    private final Supplier<Block> baseBlock;

    public ModStairBlock(Supplier<Block> baseBlock, BlockBehaviour.Properties settings) {
        super(FORGE_BLOCK_SUPPLIER == null ? ((Block)Preconditions.checkNotNull((Object)baseBlock.get(), (Object)"Stairs block was given a null base block!")).defaultBlockState() : Blocks.AIR.defaultBlockState(), settings);
        if (FORGE_BLOCK_SUPPLIER != null) {
            FORGE_BLOCK_SUPPLIER.setAccessible(true);
            try {
                FORGE_BLOCK_SUPPLIER.set((Object)this, () -> ((Block)baseBlock.get()).defaultBlockState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.baseBlock = baseBlock;
    }

    public MapCodec<? extends ModStairBlock> codec() {
        return CODEC;
    }

    public Block getBaseBlock() {
        return this.baseBlock.get();
    }
}

