/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.network;

import dev.satherov.utilityvest.common.capabilities.UVVestCapability;
import dev.satherov.utilityvest.common.item.UVVestItem;
import dev.satherov.utilityvest.core.lang.UVLanguage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SaveLoadPayload(boolean save, int hotbarIndex) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SaveLoadPayload> STREAM_CODEC = CustomPacketPayload.codec(SaveLoadPayload::encode, SaveLoadPayload::new);
    public static final CustomPacketPayload.Type<SaveLoadPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"utilityvest", (String)"save_load"));

    private SaveLoadPayload(FriendlyByteBuf buf) {
        this(buf.readBoolean(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.save);
        buf.writeInt(this.hotbarIndex);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(SaveLoadPayload msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                IItemHandler handler;
                Player patt0$temp;
                if (!ctx.flow().isServerbound() || !((patt0$temp = ctx.player()) instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack vestStack = UVVestItem.getVest((Player)player, false);
                if (!vestStack.isEmpty() && vestStack.getItem() instanceof UVVestItem && (handler = (IItemHandler)vestStack.getCapability(Capabilities.ItemHandler.ITEM)) instanceof UVVestCapability) {
                    UVVestCapability capability = (UVVestCapability)handler;
                    if (msg.save) {
                        capability.saveHotbar((Player)player, msg.hotbarIndex);
                    } else {
                        capability.loadHotbar((Player)player, msg.hotbarIndex);
                    }
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)UVLanguage.NETWORK_SAVE_LOAD_FAILED.translate(e.getMessage()));
                return null;
            });
        }
    }
}

