/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.init;

import appeng.api.AECapabilities;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import dev.satherov.growthacceleratortiers.blockentity.GATGrowthAcceleratorBlockEntity;
import dev.satherov.growthacceleratortiers.core.definitions.GATBlockEntities;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class GATInitCapabilityProviders {
    public static void register(RegisterCapabilitiesEvent event) {
        GATInitCapabilityProviders.initCrankable(event);
        for (BlockEntityType<AEBaseInvBlockEntity> blockEntityType : GATBlockEntities.getSubclassesOf(AEBaseInvBlockEntity.class)) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, AEBaseInvBlockEntity::getExposedItemHandler);
        }
        for (BlockEntityType<AEBaseInvBlockEntity> blockEntityType : GATBlockEntities.getSubclassesOf(AEBasePoweredBlockEntity.class)) {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, AEBasePoweredBlockEntity::getEnergyStorage);
        }
        for (BlockEntityType blockEntityType : GATBlockEntities.getImplementorsOf(IInWorldGridNodeHost.class)) {
            event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, blockEntityType, (object, context) -> (IInWorldGridNodeHost)object);
        }
    }

    private static void initCrankable(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.CRANKABLE, GATBlockEntities.CRANKED_GROWTH_ACCELERATOR.get(), GATGrowthAcceleratorBlockEntity::getCrankable);
        event.registerBlockEntity(AECapabilities.CRANKABLE, GATBlockEntities.DIRECTIONAL_GROWTH_ACCELERATOR.get(), GATGrowthAcceleratorBlockEntity::getCrankable);
        event.registerBlockEntity(AECapabilities.CRANKABLE, GATBlockEntities.BOOSTED_GROWTH_ACCELERATOR.get(), GATGrowthAcceleratorBlockEntity::getCrankable);
    }
}

