/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.core.events;

import dev.satherov.growthacceleratortiers.block.GATDirectionalBlock;
import dev.satherov.growthacceleratortiers.item.GATDirectionalModifier;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class GATPlayerInteractEvent {
    @SubscribeEvent
    public static void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        Level level;
        if (event.getEntity().getMainHandItem().getItem() instanceof GATDirectionalModifier && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)level;
                if (level2.getBlockState(event.getPos()).getBlock() instanceof GATDirectionalBlock) {
                    BlockPos pos = event.getPos();
                    BlockState state = level2.getBlockState(pos);
                    GATDirectionalBlock.Directions currentDir = (GATDirectionalBlock.Directions)((Object)state.getValue(GATDirectionalBlock.DIRECTION));
                    GATDirectionalBlock.Directions nextDir = GATPlayerInteractEvent.getNextDirection(currentDir);
                    level2.setBlock(pos, (BlockState)state.setValue(GATDirectionalBlock.DIRECTION, (Comparable)((Object)nextDir)), 3);
                    player.displayClientMessage((Component)Component.literal((String)GATPlayerInteractEvent.getName(nextDir)).withStyle(ChatFormatting.AQUA), true);
                }
            }
        }
    }

    private static GATDirectionalBlock.Directions getNextDirection(GATDirectionalBlock.Directions current) {
        GATDirectionalBlock.Directions[] values = GATDirectionalBlock.Directions.values();
        int nextIndex = (current.ordinal() + 1) % values.length;
        return values[nextIndex];
    }

    private static String getName(GATDirectionalBlock.Directions dir) {
        String name = dir.name().toLowerCase(Locale.ROOT);
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

