/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.blockentity;

import appeng.api.config.Actionable;
import appeng.api.ids.AETags;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.core.AEConfig;
import dev.satherov.growthacceleratortiers.block.GATGrowthAcceleratorBlock;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class GATGrowthAcceleratorBlockEntity
extends AENetworkedPoweredBlockEntity
implements IPowerChannelState {
    protected final int powerPerTick;
    protected final double multiplier;

    public GATGrowthAcceleratorBlockEntity(int maxStoredPower, int powerPerTick, double multiplier, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.powerPerTick = powerPerTick;
        this.multiplier = multiplier;
        this.setInternalMaxPower(maxStoredPower);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setIdlePowerUsage((double)powerPerTick);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)new IGridTickable(){

            public TickingRequest getTickingRequest(IGridNode node) {
                int speed = AEConfig.instance().getGrowthAcceleratorSpeed();
                return new TickingRequest(speed, speed, false);
            }

            public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
                GATGrowthAcceleratorBlockEntity.this.onTick(ticksSinceLastCall);
                return TickRateModulation.SAME;
            }
        });
    }

    protected void onTick(int ticksSinceLastCall) {
        boolean powered = this.isPowered();
        if (powered != (Boolean)this.getBlockState().getValue((Property)GATGrowthAcceleratorBlock.POWERED)) {
            this.markForUpdate();
        }
        if (!powered) {
            return;
        }
        this.extractAEPower(this.powerPerTick * ticksSinceLastCall, Actionable.MODULATE);
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = this.getBlockPos().relative(direction);
            BlockState adjState = this.getLevel().getBlockState(adjPos);
            if (!adjState.is(AETags.GROWTH_ACCELERATABLE)) continue;
            int i = 0;
            while ((double)i < this.multiplier) {
                adjState.randomTick((ServerLevel)this.getLevel(), adjPos, this.getLevel().getRandom());
                ++i;
            }
        }
    }

    public InternalInventory getInternalInventory() {
        return InternalInventory.empty();
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return orientation.getSides(EnumSet.of(RelativeSide.FRONT, RelativeSide.BACK));
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason == IGridNodeListener.State.POWER) {
            this.markForUpdate();
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.getMainNode().isPowered() || this.extractAEPower(this.powerPerTick, Actionable.SIMULATE) >= (double)this.powerPerTick;
        }
        return (Boolean)this.getBlockState().getValue((Property)GATGrowthAcceleratorBlock.POWERED);
    }

    public boolean isActive() {
        return this.isPowered();
    }

    @Nullable
    public ICrankable getCrankable(Direction direction) {
        if (this.getPowerSides().contains(direction)) {
            return new AENetworkedPoweredBlockEntity.Crankable((AENetworkedPoweredBlockEntity)this);
        }
        return null;
    }
}

