/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningPedestalTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import com.blakebr0.mysticalagriculture.util.IActivatable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AwakeningAltarTileEntity
extends BaseInventoryTileEntity
implements IActivatable {
    private static final MultiblockPositions PEDESTAL_LOCATIONS = MultiblockPositions.builder().pos(-3, 0, 0).pos(2, 0, 2).pos(3, 0, 0).pos(-2, 0, -2).pos(0, 0, -3).pos(2, 0, -2).pos(0, 0, 3).pos(-2, 0, 2).build();
    private final BaseItemStackHandler inventory = BaseItemStackHandler.create((int)2, slot -> this.setChanged(), handler -> {
        handler.setDefaultSlotLimit(1);
        handler.setCanInsert((slot, stack) -> handler.getStackInSlot(1).isEmpty());
        handler.setOutputSlots(new int[]{1});
    });
    private final BaseItemStackHandler recipeInventory = BaseItemStackHandler.create((int)9);
    private final CachedRecipe<CraftingInput, IAwakeningRecipe> recipe = new CachedRecipe((RecipeType)ModRecipeTypes.AWAKENING.get());
    private int progress;
    private boolean active;

    public AwakeningAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AWAKENING_ALTAR.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.active = tag.getBoolean("Active");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putBoolean("Active", this.active);
    }

    @Override
    public boolean isActive() {
        if (!this.active) {
            this.active = this.level != null && this.level.hasNeighborSignal(this.getBlockPos());
        }
        return this.active;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AwakeningAltarTileEntity tile) {
        ItemStack input = tile.inventory.getStackInSlot(0);
        if (input.isEmpty()) {
            tile.reset();
            tile.dispatchIfChanged();
            return;
        }
        if (tile.isActive()) {
            IAwakeningRecipe recipe = tile.getActiveRecipe();
            if (recipe != null && tile.hasRequiredEssences()) {
                ++tile.progress;
                PedestalTileEntityCollections collections = tile.getPedestalCollections();
                if (tile.progress >= 100) {
                    BaseItemStackHandler inventory;
                    int i;
                    NonNullList remaining = recipe.getRemainingItems((RecipeInput)tile.toCraftingInput());
                    for (i = 0; i < collections.pedestals.size(); ++i) {
                        AwakeningPedestalTileEntity pedestal = collections.pedestals.get(i);
                        inventory = pedestal.getInventory();
                        inventory.setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                        tile.spawnParticles(ParticleTypes.SMOKE, pedestal.getBlockPos(), 1.2, 20);
                    }
                    for (i = 0; i < collections.vessels.size(); ++i) {
                        EssenceVesselTileEntity vessel = collections.vessels.get(i);
                        inventory = vessel.getInventory();
                        inventory.setStackInSlot(0, (ItemStack)remaining.get(i + 5));
                        tile.spawnParticles(ParticleTypes.SMOKE, vessel.getBlockPos(), 1.2, 20);
                    }
                    ItemStack result = recipe.assemble((RecipeInput)tile.toCraftingInput(), (HolderLookup.Provider)level.registryAccess());
                    tile.setOutput(result, (ItemStack)remaining.getFirst());
                    tile.reset();
                    tile.setChangedFast();
                    tile.spawnParticles(ParticleTypes.HAPPY_VILLAGER, pos, 1.0, 10);
                } else {
                    for (BaseInventoryTileEntity pedestal : collections.all()) {
                        BlockPos pedestalPos = pedestal.getBlockPos();
                        ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                        tile.spawnItemParticles(pedestalPos, stack);
                    }
                }
            } else {
                tile.reset();
            }
        } else {
            tile.progress = 0;
        }
        tile.dispatchIfChanged();
    }

    public List<BlockPos> getPedestalPositions() {
        return PEDESTAL_LOCATIONS.get(this.getBlockPos());
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    public IAwakeningRecipe getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        this.updateRecipeInventory(this.getPedestalCollections());
        return (IAwakeningRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    public NonNullList<ItemStack> getEssenceItems() {
        return this.getPedestalCollections().vessels.stream().map(v -> v.getInventory().getStackInSlot(0)).collect(Collectors.toCollection(NonNullList::create));
    }

    private CraftingInput toCraftingInput() {
        return this.recipeInventory.toCraftingInput(3, 3);
    }

    private void updateRecipeInventory(PedestalTileEntityCollections collections) {
        ItemStack stack;
        int i;
        this.recipeInventory.setSize(9);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (i = 0; i < collections.pedestals.size(); ++i) {
            stack = collections.pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
        for (i = 0; i < collections.vessels.size(); ++i) {
            stack = collections.vessels.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 5, stack);
        }
    }

    private PedestalTileEntityCollections getPedestalCollections() {
        if (this.level == null) {
            return PedestalTileEntityCollections.EMPTY;
        }
        PedestalTileEntityCollections collections = new PedestalTileEntityCollections();
        for (BlockPos pos : this.getPedestalPositions()) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (tile instanceof AwakeningPedestalTileEntity) {
                AwakeningPedestalTileEntity pedestal = (AwakeningPedestalTileEntity)tile;
                collections.pedestals.add(pedestal);
            }
            if (!(tile instanceof EssenceVesselTileEntity)) continue;
            EssenceVesselTileEntity vessel = (EssenceVesselTileEntity)tile;
            collections.vessels.add(vessel);
        }
        return collections;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + yOffset;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.level == null || this.level.isClientSide() || stack.isEmpty()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        BlockPos pos = this.getBlockPos();
        double x = (double)pedestalPos.getX() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.getY() + level.getRandom().nextDouble() * 0.2 + 1.2;
        double z = (double)pedestalPos.getZ() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double velX = pos.getX() - pedestalPos.getX();
        double velY = 0.25;
        double velZ = pos.getZ() - pedestalPos.getZ();
        level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private void setOutput(ItemStack stack, ItemStack remaining) {
        NonNullList stacks = this.inventory.getStacks();
        stacks.set(0, (Object)remaining);
        stacks.set(1, (Object)stack);
    }

    private boolean hasRequiredEssences() {
        NonNullList<ItemStack> essences = this.getEssenceItems();
        return ((IAwakeningRecipe)this.recipe.get()).hasRequiredEssences((List<ItemStack>)essences);
    }

    private static class PedestalTileEntityCollections {
        public static final PedestalTileEntityCollections EMPTY = new PedestalTileEntityCollections();
        public final List<AwakeningPedestalTileEntity> pedestals = new ArrayList<AwakeningPedestalTileEntity>();
        public final List<EssenceVesselTileEntity> vessels = new ArrayList<EssenceVesselTileEntity>();

        private PedestalTileEntityCollections() {
        }

        public List<BaseInventoryTileEntity> all() {
            ArrayList<BaseInventoryTileEntity> list = new ArrayList<BaseInventoryTileEntity>();
            list.addAll(this.pedestals);
            list.addAll(this.vessels);
            return list;
        }
    }
}

