/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.tesr;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.client.EssenceVesselColorManager;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EssenceVesselRenderer
implements BlockEntityRenderer<EssenceVesselTileEntity> {
    private static final ResourceLocation VESSEL_CONTENT_TEXTURE = MysticalAgriculture.resource("block/essence_vessel_contents");

    public EssenceVesselRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EssenceVesselTileEntity tile, float v, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BaseItemStackHandler inventory = tile.getInventory();
        ItemStack stack = inventory.getStackInSlot(0);
        if (!stack.isEmpty()) {
            VertexConsumer builder = buffer.getBuffer(RenderType.solid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(VESSEL_CONTENT_TEXTURE);
            float fillPercentage = (float)stack.getCount() / (float)inventory.getSlotLimit(0);
            float filledAmount = 0.4f * fillPercentage;
            float textureOffset = (16.0f - 11.0f * fillPercentage) / 16.0f;
            matrix.pushPose();
            int color = EssenceVesselColorManager.INSTANCE.getColor(stack);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 0.75f + filledAmount, 0.8f, sprite.getU0(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 0.75f + filledAmount, 0.8f, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 0.75f + filledAmount, 0.2f, sprite.getU1(), sprite.getV0(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 0.75f + filledAmount, 0.2f, sprite.getU0(), sprite.getV0(), color, combinedLight);
            matrix.pushPose();
            matrix.translate(0.0f, 1.0f, 1.0f);
            matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 0.25f, 0.8f, sprite.getU0(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 0.25f, 0.8f, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 0.25f, 0.2f, sprite.getU1(), sprite.getV0(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 0.25f, 0.2f, sprite.getU0(), sprite.getV0(), color, combinedLight);
            matrix.popPose();
            matrix.pushPose();
            matrix.translate(1.2, 0.55, 0.0);
            matrix.mulPose(Axis.ZP.rotationDegrees(90.0f));
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.8f, sprite.getU(textureOffset), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f + filledAmount, 1.0f, 0.8f, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f + filledAmount, 1.0f, 0.2f, sprite.getU1(), sprite.getV0(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f, sprite.getU(textureOffset), sprite.getV0(), color, combinedLight);
            matrix.popPose();
            matrix.pushPose();
            matrix.translate(-0.2, 0.55, 1.0);
            matrix.mulPose(Axis.ZP.rotationDegrees(270.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.8f, sprite.getU(textureOffset), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f + filledAmount, 1.0f, 0.8f, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f + filledAmount, 1.0f, 0.2f, sprite.getU1(), sprite.getV0(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f, sprite.getU(textureOffset), sprite.getV0(), color, combinedLight);
            matrix.popPose();
            matrix.pushPose();
            matrix.translate(1.0, 0.55, -0.2);
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f + filledAmount, sprite.getU0(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 1.0f, 0.2f + filledAmount, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 1.0f, 0.2f, sprite.getU1(), sprite.getV(textureOffset), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f, sprite.getU0(), sprite.getV(textureOffset), color, combinedLight);
            matrix.popPose();
            matrix.pushPose();
            matrix.translate(0.0, 0.55, 1.2);
            matrix.mulPose(Axis.XP.rotationDegrees(270.0f));
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f + filledAmount, sprite.getU0(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 1.0f, 0.2f + filledAmount, sprite.getU1(), sprite.getV1(), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.8f, 1.0f, 0.2f, sprite.getU1(), sprite.getV(textureOffset), color, combinedLight);
            EssenceVesselRenderer.addVertex(builder, matrix, 0.2f, 1.0f, 0.2f, sprite.getU0(), sprite.getV(textureOffset), color, combinedLight);
            matrix.popPose();
            matrix.popPose();
        }
    }

    private static void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int color, int combinedLight) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(combinedLight).setNormal(1.0f, 0.0f, 0.0f);
    }
}

