/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

public class EssenceVesselColorManager
implements PreparableReloadListener {
    public static final EssenceVesselColorManager INSTANCE = new EssenceVesselColorManager();
    private final HashMap<String, Integer> colors = new HashMap();

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)this);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            if (!ModLoader.hasErrors()) {
                this.load(manager);
            }
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0));
    }

    public int getColor(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return this.colors.getOrDefault(id.toString(), 0xFFFFFF);
    }

    private void load(ResourceManager manager) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map resources = manager.listResources("essence_vessel_colors.json", s -> s.getPath().endsWith(".json"));
        this.colors.clear();
        for (Map.Entry resource : resources.entrySet()) {
            try {
                BufferedReader reader = ((Resource)resource.getValue()).openAsReader();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : json.entrySet()) {
                        String item = (String)entry.getKey();
                        int color = ParsingHelper.parseHex((String)((JsonElement)entry.getValue()).getAsString(), (String)item);
                        this.colors.put(item, color);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                MysticalAgriculture.LOGGER.error("Failed to load {}", resource.getKey(), (Object)e);
            }
        }
        MysticalAgriculture.LOGGER.info("Loaded {} essence vessel colors in {} ms", (Object)this.colors.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

